package zio.aws.cloudformation.model
import zio.aws.cloudformation.model.primitives.{
  TypeVersionId,
  PublisherId,
  PublicVersionNumber,
  TypeArn,
  Timestamp,
  PublisherName,
  IsActivated,
  Description,
  TypeName
}
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import java.time.Instant
import scala.jdk.CollectionConverters._
final case class TypeSummary(
    `type`: Option[zio.aws.cloudformation.model.RegistryType] = None,
    typeName: Option[TypeName] = None,
    defaultVersionId: Option[TypeVersionId] = None,
    typeArn: Option[TypeArn] = None,
    lastUpdated: Option[Timestamp] = None,
    description: Option[Description] = None,
    publisherId: Option[PublisherId] = None,
    originalTypeName: Option[TypeName] = None,
    publicVersionNumber: Option[PublicVersionNumber] = None,
    latestPublicVersion: Option[PublicVersionNumber] = None,
    publisherIdentity: Option[zio.aws.cloudformation.model.IdentityProvider] =
      None,
    publisherName: Option[PublisherName] = None,
    isActivated: Option[IsActivated] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.cloudformation.model.TypeSummary = {
    import TypeSummary.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.cloudformation.model.TypeSummary
      .builder()
      .optionallyWith(`type`.map(value => value.unwrap))(_.`type`)
      .optionallyWith(
        typeName.map(value => TypeName.unwrap(value): java.lang.String)
      )(_.typeName)
      .optionallyWith(
        defaultVersionId.map(value =>
          TypeVersionId.unwrap(value): java.lang.String
        )
      )(_.defaultVersionId)
      .optionallyWith(
        typeArn.map(value => TypeArn.unwrap(value): java.lang.String)
      )(_.typeArn)
      .optionallyWith(
        lastUpdated.map(value => Timestamp.unwrap(value): Instant)
      )(_.lastUpdated)
      .optionallyWith(
        description.map(value => Description.unwrap(value): java.lang.String)
      )(_.description)
      .optionallyWith(
        publisherId.map(value => PublisherId.unwrap(value): java.lang.String)
      )(_.publisherId)
      .optionallyWith(
        originalTypeName.map(value => TypeName.unwrap(value): java.lang.String)
      )(_.originalTypeName)
      .optionallyWith(
        publicVersionNumber.map(value =>
          PublicVersionNumber.unwrap(value): java.lang.String
        )
      )(_.publicVersionNumber)
      .optionallyWith(
        latestPublicVersion.map(value =>
          PublicVersionNumber.unwrap(value): java.lang.String
        )
      )(_.latestPublicVersion)
      .optionallyWith(publisherIdentity.map(value => value.unwrap))(
        _.publisherIdentity
      )
      .optionallyWith(
        publisherName.map(value =>
          PublisherName.unwrap(value): java.lang.String
        )
      )(_.publisherName)
      .optionallyWith(
        isActivated.map(value => IsActivated.unwrap(value): java.lang.Boolean)
      )(_.isActivated)
      .build()
  }
  def asReadOnly: zio.aws.cloudformation.model.TypeSummary.ReadOnly =
    zio.aws.cloudformation.model.TypeSummary.wrap(buildAwsValue())
}
object TypeSummary {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.cloudformation.model.TypeSummary
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.cloudformation.model.TypeSummary =
      zio.aws.cloudformation.model.TypeSummary(
        `type`.map(value => value),
        typeName.map(value => value),
        defaultVersionId.map(value => value),
        typeArn.map(value => value),
        lastUpdated.map(value => value),
        description.map(value => value),
        publisherId.map(value => value),
        originalTypeName.map(value => value),
        publicVersionNumber.map(value => value),
        latestPublicVersion.map(value => value),
        publisherIdentity.map(value => value),
        publisherName.map(value => value),
        isActivated.map(value => value)
      )
    def `type`: Option[zio.aws.cloudformation.model.RegistryType]
    def typeName: Option[TypeName]
    def defaultVersionId: Option[TypeVersionId]
    def typeArn: Option[TypeArn]
    def lastUpdated: Option[Timestamp]
    def description: Option[Description]
    def publisherId: Option[PublisherId]
    def originalTypeName: Option[TypeName]
    def publicVersionNumber: Option[PublicVersionNumber]
    def latestPublicVersion: Option[PublicVersionNumber]
    def publisherIdentity: Option[zio.aws.cloudformation.model.IdentityProvider]
    def publisherName: Option[PublisherName]
    def isActivated: Option[IsActivated]
    def getType: ZIO[Any, AwsError, zio.aws.cloudformation.model.RegistryType] =
      AwsError.unwrapOptionField("type", `type`)
    def getTypeName: ZIO[Any, AwsError, TypeName] =
      AwsError.unwrapOptionField("typeName", typeName)
    def getDefaultVersionId: ZIO[Any, AwsError, TypeVersionId] =
      AwsError.unwrapOptionField("defaultVersionId", defaultVersionId)
    def getTypeArn: ZIO[Any, AwsError, TypeArn] =
      AwsError.unwrapOptionField("typeArn", typeArn)
    def getLastUpdated: ZIO[Any, AwsError, Timestamp] =
      AwsError.unwrapOptionField("lastUpdated", lastUpdated)
    def getDescription: ZIO[Any, AwsError, Description] =
      AwsError.unwrapOptionField("description", description)
    def getPublisherId: ZIO[Any, AwsError, PublisherId] =
      AwsError.unwrapOptionField("publisherId", publisherId)
    def getOriginalTypeName: ZIO[Any, AwsError, TypeName] =
      AwsError.unwrapOptionField("originalTypeName", originalTypeName)
    def getPublicVersionNumber: ZIO[Any, AwsError, PublicVersionNumber] =
      AwsError.unwrapOptionField("publicVersionNumber", publicVersionNumber)
    def getLatestPublicVersion: ZIO[Any, AwsError, PublicVersionNumber] =
      AwsError.unwrapOptionField("latestPublicVersion", latestPublicVersion)
    def getPublisherIdentity
        : ZIO[Any, AwsError, zio.aws.cloudformation.model.IdentityProvider] =
      AwsError.unwrapOptionField("publisherIdentity", publisherIdentity)
    def getPublisherName: ZIO[Any, AwsError, PublisherName] =
      AwsError.unwrapOptionField("publisherName", publisherName)
    def getIsActivated: ZIO[Any, AwsError, IsActivated] =
      AwsError.unwrapOptionField("isActivated", isActivated)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.cloudformation.model.TypeSummary
  ) extends zio.aws.cloudformation.model.TypeSummary.ReadOnly {
    override val `type`: Option[zio.aws.cloudformation.model.RegistryType] =
      scala
        .Option(impl.`type`())
        .map(value => zio.aws.cloudformation.model.RegistryType.wrap(value))
    override val typeName: Option[TypeName] = scala
      .Option(impl.typeName())
      .map(value => zio.aws.cloudformation.model.primitives.TypeName(value))
    override val defaultVersionId: Option[TypeVersionId] = scala
      .Option(impl.defaultVersionId())
      .map(value =>
        zio.aws.cloudformation.model.primitives.TypeVersionId(value)
      )
    override val typeArn: Option[TypeArn] = scala
      .Option(impl.typeArn())
      .map(value => zio.aws.cloudformation.model.primitives.TypeArn(value))
    override val lastUpdated: Option[Timestamp] = scala
      .Option(impl.lastUpdated())
      .map(value => zio.aws.cloudformation.model.primitives.Timestamp(value))
    override val description: Option[Description] = scala
      .Option(impl.description())
      .map(value => zio.aws.cloudformation.model.primitives.Description(value))
    override val publisherId: Option[PublisherId] = scala
      .Option(impl.publisherId())
      .map(value => zio.aws.cloudformation.model.primitives.PublisherId(value))
    override val originalTypeName: Option[TypeName] = scala
      .Option(impl.originalTypeName())
      .map(value => zio.aws.cloudformation.model.primitives.TypeName(value))
    override val publicVersionNumber: Option[PublicVersionNumber] = scala
      .Option(impl.publicVersionNumber())
      .map(value =>
        zio.aws.cloudformation.model.primitives.PublicVersionNumber(value)
      )
    override val latestPublicVersion: Option[PublicVersionNumber] = scala
      .Option(impl.latestPublicVersion())
      .map(value =>
        zio.aws.cloudformation.model.primitives.PublicVersionNumber(value)
      )
    override val publisherIdentity
        : Option[zio.aws.cloudformation.model.IdentityProvider] = scala
      .Option(impl.publisherIdentity())
      .map(value => zio.aws.cloudformation.model.IdentityProvider.wrap(value))
    override val publisherName: Option[PublisherName] = scala
      .Option(impl.publisherName())
      .map(value =>
        zio.aws.cloudformation.model.primitives.PublisherName(value)
      )
    override val isActivated: Option[IsActivated] = scala
      .Option(impl.isActivated())
      .map(value => zio.aws.cloudformation.model.primitives.IsActivated(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.cloudformation.model.TypeSummary
  ): zio.aws.cloudformation.model.TypeSummary.ReadOnly = new Wrapper(impl)
}
