package zio.aws.cloudformation.model
import scala.jdk.CollectionConverters._
sealed trait ThirdPartyType {
  def unwrap
      : software.amazon.awssdk.services.cloudformation.model.ThirdPartyType
}
object ThirdPartyType {
  def wrap(
      value: software.amazon.awssdk.services.cloudformation.model.ThirdPartyType
  ): zio.aws.cloudformation.model.ThirdPartyType = value match {
    case software.amazon.awssdk.services.cloudformation.model.ThirdPartyType.UNKNOWN_TO_SDK_VERSION =>
      val r = unknownToSdkVersion
      r
    case software.amazon.awssdk.services.cloudformation.model.ThirdPartyType.RESOURCE =>
      val r = RESOURCE
      r
    case software.amazon.awssdk.services.cloudformation.model.ThirdPartyType.MODULE =>
      val r = MODULE
      r
  }
  case object unknownToSdkVersion
      extends zio.aws.cloudformation.model.ThirdPartyType {
    override def unwrap
        : software.amazon.awssdk.services.cloudformation.model.ThirdPartyType =
      software.amazon.awssdk.services.cloudformation.model.ThirdPartyType.UNKNOWN_TO_SDK_VERSION
  }
  case object RESOURCE extends zio.aws.cloudformation.model.ThirdPartyType {
    override def unwrap
        : software.amazon.awssdk.services.cloudformation.model.ThirdPartyType =
      software.amazon.awssdk.services.cloudformation.model.ThirdPartyType.RESOURCE
  }
  case object MODULE extends zio.aws.cloudformation.model.ThirdPartyType {
    override def unwrap
        : software.amazon.awssdk.services.cloudformation.model.ThirdPartyType =
      software.amazon.awssdk.services.cloudformation.model.ThirdPartyType.MODULE
  }
}
