package zio.aws.cloudformation.model
import zio.aws.cloudformation.model.primitives.StackInstanceFilterValues
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters._
final case class StackInstanceFilter(
    name: Option[zio.aws.cloudformation.model.StackInstanceFilterName] = None,
    values: Option[StackInstanceFilterValues] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.cloudformation.model.StackInstanceFilter = {
    import StackInstanceFilter.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.cloudformation.model.StackInstanceFilter
      .builder()
      .optionallyWith(name.map(value => value.unwrap))(_.name)
      .optionallyWith(
        values.map(value =>
          StackInstanceFilterValues.unwrap(value): java.lang.String
        )
      )(_.values)
      .build()
  }
  def asReadOnly: zio.aws.cloudformation.model.StackInstanceFilter.ReadOnly =
    zio.aws.cloudformation.model.StackInstanceFilter.wrap(buildAwsValue())
}
object StackInstanceFilter {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.cloudformation.model.StackInstanceFilter
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.cloudformation.model.StackInstanceFilter =
      zio.aws.cloudformation.model.StackInstanceFilter(
        name.map(value => value),
        values.map(value => value)
      )
    def name: Option[zio.aws.cloudformation.model.StackInstanceFilterName]
    def values: Option[StackInstanceFilterValues]
    def getName: ZIO[
      Any,
      AwsError,
      zio.aws.cloudformation.model.StackInstanceFilterName
    ] = AwsError.unwrapOptionField("name", name)
    def getValues: ZIO[Any, AwsError, StackInstanceFilterValues] =
      AwsError.unwrapOptionField("values", values)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.cloudformation.model.StackInstanceFilter
  ) extends zio.aws.cloudformation.model.StackInstanceFilter.ReadOnly {
    override val name
        : Option[zio.aws.cloudformation.model.StackInstanceFilterName] = scala
      .Option(impl.name())
      .map(value =>
        zio.aws.cloudformation.model.StackInstanceFilterName.wrap(value)
      )
    override val values: Option[StackInstanceFilterValues] = scala
      .Option(impl.values())
      .map(value =>
        zio.aws.cloudformation.model.primitives.StackInstanceFilterValues(value)
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.cloudformation.model.StackInstanceFilter
  ): zio.aws.cloudformation.model.StackInstanceFilter.ReadOnly = new Wrapper(
    impl
  )
}
