package zio.aws.cloudformation.model
import scala.jdk.CollectionConverters._
sealed trait Replacement {
  def unwrap: software.amazon.awssdk.services.cloudformation.model.Replacement
}
object Replacement {
  def wrap(
      value: software.amazon.awssdk.services.cloudformation.model.Replacement
  ): zio.aws.cloudformation.model.Replacement = value match {
    case software.amazon.awssdk.services.cloudformation.model.Replacement.UNKNOWN_TO_SDK_VERSION =>
      val r = unknownToSdkVersion
      r
    case software.amazon.awssdk.services.cloudformation.model.Replacement.TRUE =>
      val r = True
      r
    case software.amazon.awssdk.services.cloudformation.model.Replacement.FALSE =>
      val r = False
      r
    case software.amazon.awssdk.services.cloudformation.model.Replacement.CONDITIONAL =>
      val r = Conditional
      r
  }
  case object unknownToSdkVersion
      extends zio.aws.cloudformation.model.Replacement {
    override def unwrap
        : software.amazon.awssdk.services.cloudformation.model.Replacement =
      software.amazon.awssdk.services.cloudformation.model.Replacement.UNKNOWN_TO_SDK_VERSION
  }
  case object True extends zio.aws.cloudformation.model.Replacement {
    override def unwrap
        : software.amazon.awssdk.services.cloudformation.model.Replacement =
      software.amazon.awssdk.services.cloudformation.model.Replacement.TRUE
  }
  case object False extends zio.aws.cloudformation.model.Replacement {
    override def unwrap
        : software.amazon.awssdk.services.cloudformation.model.Replacement =
      software.amazon.awssdk.services.cloudformation.model.Replacement.FALSE
  }
  case object Conditional extends zio.aws.cloudformation.model.Replacement {
    override def unwrap
        : software.amazon.awssdk.services.cloudformation.model.Replacement =
      software.amazon.awssdk.services.cloudformation.model.Replacement.CONDITIONAL
  }
}
