package zio.aws.cloudformation.model
import scala.jdk.CollectionConverters._
sealed trait OnFailure {
  def unwrap: software.amazon.awssdk.services.cloudformation.model.OnFailure
}
object OnFailure {
  def wrap(
      value: software.amazon.awssdk.services.cloudformation.model.OnFailure
  ): zio.aws.cloudformation.model.OnFailure = value match {
    case software.amazon.awssdk.services.cloudformation.model.OnFailure.UNKNOWN_TO_SDK_VERSION =>
      val r = unknownToSdkVersion
      r
    case software.amazon.awssdk.services.cloudformation.model.OnFailure.DO_NOTHING =>
      val r = DO_NOTHING
      r
    case software.amazon.awssdk.services.cloudformation.model.OnFailure.ROLLBACK =>
      val r = ROLLBACK
      r
    case software.amazon.awssdk.services.cloudformation.model.OnFailure.DELETE =>
      val r = DELETE
      r
  }
  case object unknownToSdkVersion
      extends zio.aws.cloudformation.model.OnFailure {
    override def unwrap
        : software.amazon.awssdk.services.cloudformation.model.OnFailure =
      software.amazon.awssdk.services.cloudformation.model.OnFailure.UNKNOWN_TO_SDK_VERSION
  }
  case object DO_NOTHING extends zio.aws.cloudformation.model.OnFailure {
    override def unwrap
        : software.amazon.awssdk.services.cloudformation.model.OnFailure =
      software.amazon.awssdk.services.cloudformation.model.OnFailure.DO_NOTHING
  }
  case object ROLLBACK extends zio.aws.cloudformation.model.OnFailure {
    override def unwrap
        : software.amazon.awssdk.services.cloudformation.model.OnFailure =
      software.amazon.awssdk.services.cloudformation.model.OnFailure.ROLLBACK
  }
  case object DELETE extends zio.aws.cloudformation.model.OnFailure {
    override def unwrap
        : software.amazon.awssdk.services.cloudformation.model.OnFailure =
      software.amazon.awssdk.services.cloudformation.model.OnFailure.DELETE
  }
}
