package zio.aws.cloudformation.model
import zio.aws.cloudformation.model.primitives.{
  LogicalIdHierarchy,
  TypeHierarchy
}
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters._
final case class ModuleInfo(
    typeHierarchy: Option[TypeHierarchy] = None,
    logicalIdHierarchy: Option[LogicalIdHierarchy] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.cloudformation.model.ModuleInfo = {
    import ModuleInfo.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.cloudformation.model.ModuleInfo
      .builder()
      .optionallyWith(
        typeHierarchy.map(value =>
          TypeHierarchy.unwrap(value): java.lang.String
        )
      )(_.typeHierarchy)
      .optionallyWith(
        logicalIdHierarchy.map(value =>
          LogicalIdHierarchy.unwrap(value): java.lang.String
        )
      )(_.logicalIdHierarchy)
      .build()
  }
  def asReadOnly: zio.aws.cloudformation.model.ModuleInfo.ReadOnly =
    zio.aws.cloudformation.model.ModuleInfo.wrap(buildAwsValue())
}
object ModuleInfo {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.cloudformation.model.ModuleInfo
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.cloudformation.model.ModuleInfo =
      zio.aws.cloudformation.model.ModuleInfo(
        typeHierarchy.map(value => value),
        logicalIdHierarchy.map(value => value)
      )
    def typeHierarchy: Option[TypeHierarchy]
    def logicalIdHierarchy: Option[LogicalIdHierarchy]
    def getTypeHierarchy: ZIO[Any, AwsError, TypeHierarchy] =
      AwsError.unwrapOptionField("typeHierarchy", typeHierarchy)
    def getLogicalIdHierarchy: ZIO[Any, AwsError, LogicalIdHierarchy] =
      AwsError.unwrapOptionField("logicalIdHierarchy", logicalIdHierarchy)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.cloudformation.model.ModuleInfo
  ) extends zio.aws.cloudformation.model.ModuleInfo.ReadOnly {
    override val typeHierarchy: Option[TypeHierarchy] = scala
      .Option(impl.typeHierarchy())
      .map(value =>
        zio.aws.cloudformation.model.primitives.TypeHierarchy(value)
      )
    override val logicalIdHierarchy: Option[LogicalIdHierarchy] = scala
      .Option(impl.logicalIdHierarchy())
      .map(value =>
        zio.aws.cloudformation.model.primitives.LogicalIdHierarchy(value)
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.cloudformation.model.ModuleInfo
  ): zio.aws.cloudformation.model.ModuleInfo.ReadOnly = new Wrapper(impl)
}
