package zio.aws.cloudformation.model
import scala.jdk.CollectionConverters._
sealed trait ChangeSetType {
  def unwrap: software.amazon.awssdk.services.cloudformation.model.ChangeSetType
}
object ChangeSetType {
  def wrap(
      value: software.amazon.awssdk.services.cloudformation.model.ChangeSetType
  ): zio.aws.cloudformation.model.ChangeSetType = value match {
    case software.amazon.awssdk.services.cloudformation.model.ChangeSetType.UNKNOWN_TO_SDK_VERSION =>
      val r = unknownToSdkVersion
      r
    case software.amazon.awssdk.services.cloudformation.model.ChangeSetType.CREATE =>
      val r = CREATE
      r
    case software.amazon.awssdk.services.cloudformation.model.ChangeSetType.UPDATE =>
      val r = UPDATE
      r
    case software.amazon.awssdk.services.cloudformation.model.ChangeSetType.IMPORT =>
      val r = IMPORT
      r
  }
  case object unknownToSdkVersion
      extends zio.aws.cloudformation.model.ChangeSetType {
    override def unwrap
        : software.amazon.awssdk.services.cloudformation.model.ChangeSetType =
      software.amazon.awssdk.services.cloudformation.model.ChangeSetType.UNKNOWN_TO_SDK_VERSION
  }
  case object CREATE extends zio.aws.cloudformation.model.ChangeSetType {
    override def unwrap
        : software.amazon.awssdk.services.cloudformation.model.ChangeSetType =
      software.amazon.awssdk.services.cloudformation.model.ChangeSetType.CREATE
  }
  case object UPDATE extends zio.aws.cloudformation.model.ChangeSetType {
    override def unwrap
        : software.amazon.awssdk.services.cloudformation.model.ChangeSetType =
      software.amazon.awssdk.services.cloudformation.model.ChangeSetType.UPDATE
  }
  case object IMPORT extends zio.aws.cloudformation.model.ChangeSetType {
    override def unwrap
        : software.amazon.awssdk.services.cloudformation.model.ChangeSetType =
      software.amazon.awssdk.services.cloudformation.model.ChangeSetType.IMPORT
  }
}
