package zio.aws.cloudformation.model
import zio.aws.cloudformation.model.primitives.{
  CreationTime,
  ChangeSetName,
  StackName,
  IncludeNestedStacks,
  StackId,
  Description,
  ChangeSetId,
  ChangeSetStatusReason
}
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import java.time.Instant
import scala.jdk.CollectionConverters._
final case class ChangeSetSummary(
    stackId: Option[StackId] = None,
    stackName: Option[StackName] = None,
    changeSetId: Option[ChangeSetId] = None,
    changeSetName: Option[ChangeSetName] = None,
    executionStatus: Option[zio.aws.cloudformation.model.ExecutionStatus] =
      None,
    status: Option[zio.aws.cloudformation.model.ChangeSetStatus] = None,
    statusReason: Option[ChangeSetStatusReason] = None,
    creationTime: Option[CreationTime] = None,
    description: Option[Description] = None,
    includeNestedStacks: Option[IncludeNestedStacks] = None,
    parentChangeSetId: Option[ChangeSetId] = None,
    rootChangeSetId: Option[ChangeSetId] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.cloudformation.model.ChangeSetSummary = {
    import ChangeSetSummary.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.cloudformation.model.ChangeSetSummary
      .builder()
      .optionallyWith(
        stackId.map(value => StackId.unwrap(value): java.lang.String)
      )(_.stackId)
      .optionallyWith(
        stackName.map(value => StackName.unwrap(value): java.lang.String)
      )(_.stackName)
      .optionallyWith(
        changeSetId.map(value => ChangeSetId.unwrap(value): java.lang.String)
      )(_.changeSetId)
      .optionallyWith(
        changeSetName.map(value =>
          ChangeSetName.unwrap(value): java.lang.String
        )
      )(_.changeSetName)
      .optionallyWith(executionStatus.map(value => value.unwrap))(
        _.executionStatus
      )
      .optionallyWith(status.map(value => value.unwrap))(_.status)
      .optionallyWith(
        statusReason.map(value =>
          ChangeSetStatusReason.unwrap(value): java.lang.String
        )
      )(_.statusReason)
      .optionallyWith(
        creationTime.map(value => CreationTime.unwrap(value): Instant)
      )(_.creationTime)
      .optionallyWith(
        description.map(value => Description.unwrap(value): java.lang.String)
      )(_.description)
      .optionallyWith(
        includeNestedStacks.map(value =>
          IncludeNestedStacks.unwrap(value): java.lang.Boolean
        )
      )(_.includeNestedStacks)
      .optionallyWith(
        parentChangeSetId.map(value =>
          ChangeSetId.unwrap(value): java.lang.String
        )
      )(_.parentChangeSetId)
      .optionallyWith(
        rootChangeSetId.map(value =>
          ChangeSetId.unwrap(value): java.lang.String
        )
      )(_.rootChangeSetId)
      .build()
  }
  def asReadOnly: zio.aws.cloudformation.model.ChangeSetSummary.ReadOnly =
    zio.aws.cloudformation.model.ChangeSetSummary.wrap(buildAwsValue())
}
object ChangeSetSummary {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.cloudformation.model.ChangeSetSummary
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.cloudformation.model.ChangeSetSummary =
      zio.aws.cloudformation.model.ChangeSetSummary(
        stackId.map(value => value),
        stackName.map(value => value),
        changeSetId.map(value => value),
        changeSetName.map(value => value),
        executionStatus.map(value => value),
        status.map(value => value),
        statusReason.map(value => value),
        creationTime.map(value => value),
        description.map(value => value),
        includeNestedStacks.map(value => value),
        parentChangeSetId.map(value => value),
        rootChangeSetId.map(value => value)
      )
    def stackId: Option[StackId]
    def stackName: Option[StackName]
    def changeSetId: Option[ChangeSetId]
    def changeSetName: Option[ChangeSetName]
    def executionStatus: Option[zio.aws.cloudformation.model.ExecutionStatus]
    def status: Option[zio.aws.cloudformation.model.ChangeSetStatus]
    def statusReason: Option[ChangeSetStatusReason]
    def creationTime: Option[CreationTime]
    def description: Option[Description]
    def includeNestedStacks: Option[IncludeNestedStacks]
    def parentChangeSetId: Option[ChangeSetId]
    def rootChangeSetId: Option[ChangeSetId]
    def getStackId: ZIO[Any, AwsError, StackId] =
      AwsError.unwrapOptionField("stackId", stackId)
    def getStackName: ZIO[Any, AwsError, StackName] =
      AwsError.unwrapOptionField("stackName", stackName)
    def getChangeSetId: ZIO[Any, AwsError, ChangeSetId] =
      AwsError.unwrapOptionField("changeSetId", changeSetId)
    def getChangeSetName: ZIO[Any, AwsError, ChangeSetName] =
      AwsError.unwrapOptionField("changeSetName", changeSetName)
    def getExecutionStatus
        : ZIO[Any, AwsError, zio.aws.cloudformation.model.ExecutionStatus] =
      AwsError.unwrapOptionField("executionStatus", executionStatus)
    def getStatus
        : ZIO[Any, AwsError, zio.aws.cloudformation.model.ChangeSetStatus] =
      AwsError.unwrapOptionField("status", status)
    def getStatusReason: ZIO[Any, AwsError, ChangeSetStatusReason] =
      AwsError.unwrapOptionField("statusReason", statusReason)
    def getCreationTime: ZIO[Any, AwsError, CreationTime] =
      AwsError.unwrapOptionField("creationTime", creationTime)
    def getDescription: ZIO[Any, AwsError, Description] =
      AwsError.unwrapOptionField("description", description)
    def getIncludeNestedStacks: ZIO[Any, AwsError, IncludeNestedStacks] =
      AwsError.unwrapOptionField("includeNestedStacks", includeNestedStacks)
    def getParentChangeSetId: ZIO[Any, AwsError, ChangeSetId] =
      AwsError.unwrapOptionField("parentChangeSetId", parentChangeSetId)
    def getRootChangeSetId: ZIO[Any, AwsError, ChangeSetId] =
      AwsError.unwrapOptionField("rootChangeSetId", rootChangeSetId)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.cloudformation.model.ChangeSetSummary
  ) extends zio.aws.cloudformation.model.ChangeSetSummary.ReadOnly {
    override val stackId: Option[StackId] = scala
      .Option(impl.stackId())
      .map(value => zio.aws.cloudformation.model.primitives.StackId(value))
    override val stackName: Option[StackName] = scala
      .Option(impl.stackName())
      .map(value => zio.aws.cloudformation.model.primitives.StackName(value))
    override val changeSetId: Option[ChangeSetId] = scala
      .Option(impl.changeSetId())
      .map(value => zio.aws.cloudformation.model.primitives.ChangeSetId(value))
    override val changeSetName: Option[ChangeSetName] = scala
      .Option(impl.changeSetName())
      .map(value =>
        zio.aws.cloudformation.model.primitives.ChangeSetName(value)
      )
    override val executionStatus
        : Option[zio.aws.cloudformation.model.ExecutionStatus] = scala
      .Option(impl.executionStatus())
      .map(value => zio.aws.cloudformation.model.ExecutionStatus.wrap(value))
    override val status: Option[zio.aws.cloudformation.model.ChangeSetStatus] =
      scala
        .Option(impl.status())
        .map(value => zio.aws.cloudformation.model.ChangeSetStatus.wrap(value))
    override val statusReason: Option[ChangeSetStatusReason] = scala
      .Option(impl.statusReason())
      .map(value =>
        zio.aws.cloudformation.model.primitives.ChangeSetStatusReason(value)
      )
    override val creationTime: Option[CreationTime] = scala
      .Option(impl.creationTime())
      .map(value => zio.aws.cloudformation.model.primitives.CreationTime(value))
    override val description: Option[Description] = scala
      .Option(impl.description())
      .map(value => zio.aws.cloudformation.model.primitives.Description(value))
    override val includeNestedStacks: Option[IncludeNestedStacks] = scala
      .Option(impl.includeNestedStacks())
      .map(value =>
        zio.aws.cloudformation.model.primitives.IncludeNestedStacks(value)
      )
    override val parentChangeSetId: Option[ChangeSetId] = scala
      .Option(impl.parentChangeSetId())
      .map(value => zio.aws.cloudformation.model.primitives.ChangeSetId(value))
    override val rootChangeSetId: Option[ChangeSetId] = scala
      .Option(impl.rootChangeSetId())
      .map(value => zio.aws.cloudformation.model.primitives.ChangeSetId(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.cloudformation.model.ChangeSetSummary
  ): zio.aws.cloudformation.model.ChangeSetSummary.ReadOnly = new Wrapper(impl)
}
