package zio.aws.cloudformation.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters._
final case class BatchDescribeTypeConfigurationsResponse(
    errors: Option[Iterable[
      zio.aws.cloudformation.model.BatchDescribeTypeConfigurationsError
    ]] = None,
    unprocessedTypeConfigurations: Option[
      Iterable[zio.aws.cloudformation.model.TypeConfigurationIdentifier]
    ] = None,
    typeConfigurations: Option[
      Iterable[zio.aws.cloudformation.model.TypeConfigurationDetails]
    ] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.cloudformation.model.BatchDescribeTypeConfigurationsResponse = {
    import BatchDescribeTypeConfigurationsResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.cloudformation.model.BatchDescribeTypeConfigurationsResponse
      .builder()
      .optionallyWith(
        errors.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.errors)
      .optionallyWith(
        unprocessedTypeConfigurations.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.unprocessedTypeConfigurations)
      .optionallyWith(
        typeConfigurations.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.typeConfigurations)
      .build()
  }
  def asReadOnly
      : zio.aws.cloudformation.model.BatchDescribeTypeConfigurationsResponse.ReadOnly =
    zio.aws.cloudformation.model.BatchDescribeTypeConfigurationsResponse
      .wrap(buildAwsValue())
}
object BatchDescribeTypeConfigurationsResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.cloudformation.model.BatchDescribeTypeConfigurationsResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.cloudformation.model.BatchDescribeTypeConfigurationsResponse =
      zio.aws.cloudformation.model.BatchDescribeTypeConfigurationsResponse(
        errors.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        unprocessedTypeConfigurations.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        typeConfigurations.map(value =>
          value.map { item =>
            item.asEditable
          }
        )
      )
    def errors: Option[List[
      zio.aws.cloudformation.model.BatchDescribeTypeConfigurationsError.ReadOnly
    ]]
    def unprocessedTypeConfigurations: Option[
      List[zio.aws.cloudformation.model.TypeConfigurationIdentifier.ReadOnly]
    ]
    def typeConfigurations: Option[
      List[zio.aws.cloudformation.model.TypeConfigurationDetails.ReadOnly]
    ]
    def getErrors: ZIO[Any, AwsError, List[
      zio.aws.cloudformation.model.BatchDescribeTypeConfigurationsError.ReadOnly
    ]] = AwsError.unwrapOptionField("errors", errors)
    def getUnprocessedTypeConfigurations: ZIO[Any, AwsError, List[
      zio.aws.cloudformation.model.TypeConfigurationIdentifier.ReadOnly
    ]] = AwsError.unwrapOptionField(
      "unprocessedTypeConfigurations",
      unprocessedTypeConfigurations
    )
    def getTypeConfigurations: ZIO[Any, AwsError, List[
      zio.aws.cloudformation.model.TypeConfigurationDetails.ReadOnly
    ]] = AwsError.unwrapOptionField("typeConfigurations", typeConfigurations)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.cloudformation.model.BatchDescribeTypeConfigurationsResponse
  ) extends zio.aws.cloudformation.model.BatchDescribeTypeConfigurationsResponse.ReadOnly {
    override val errors: Option[List[
      zio.aws.cloudformation.model.BatchDescribeTypeConfigurationsError.ReadOnly
    ]] = scala
      .Option(impl.errors())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.cloudformation.model.BatchDescribeTypeConfigurationsError
            .wrap(item)
        }.toList
      )
    override val unprocessedTypeConfigurations: Option[
      List[zio.aws.cloudformation.model.TypeConfigurationIdentifier.ReadOnly]
    ] = scala
      .Option(impl.unprocessedTypeConfigurations())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.cloudformation.model.TypeConfigurationIdentifier.wrap(item)
        }.toList
      )
    override val typeConfigurations: Option[
      List[zio.aws.cloudformation.model.TypeConfigurationDetails.ReadOnly]
    ] = scala
      .Option(impl.typeConfigurations())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.cloudformation.model.TypeConfigurationDetails.wrap(item)
        }.toList
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.cloudformation.model.BatchDescribeTypeConfigurationsResponse
  ): zio.aws.cloudformation.model.BatchDescribeTypeConfigurationsResponse.ReadOnly =
    new Wrapper(impl)
}
