package zio.aws.cloudformation.model
import scala.jdk.CollectionConverters._
sealed trait StackSetDriftDetectionStatus {
  def unwrap: software.amazon.awssdk.services.cloudformation.model.StackSetDriftDetectionStatus
}
object StackSetDriftDetectionStatus {
  def wrap(
      value: software.amazon.awssdk.services.cloudformation.model.StackSetDriftDetectionStatus
  ): zio.aws.cloudformation.model.StackSetDriftDetectionStatus = value match {
    case software.amazon.awssdk.services.cloudformation.model.StackSetDriftDetectionStatus.UNKNOWN_TO_SDK_VERSION =>
      val r = unknownToSdkVersion
      r
    case software.amazon.awssdk.services.cloudformation.model.StackSetDriftDetectionStatus.COMPLETED =>
      val r = COMPLETED
      r
    case software.amazon.awssdk.services.cloudformation.model.StackSetDriftDetectionStatus.FAILED =>
      val r = FAILED
      r
    case software.amazon.awssdk.services.cloudformation.model.StackSetDriftDetectionStatus.PARTIAL_SUCCESS =>
      val r = PARTIAL_SUCCESS
      r
    case software.amazon.awssdk.services.cloudformation.model.StackSetDriftDetectionStatus.IN_PROGRESS =>
      val r = IN_PROGRESS
      r
    case software.amazon.awssdk.services.cloudformation.model.StackSetDriftDetectionStatus.STOPPED =>
      val r = STOPPED
      r
  }
  case object unknownToSdkVersion
      extends zio.aws.cloudformation.model.StackSetDriftDetectionStatus {
    override def unwrap
        : software.amazon.awssdk.services.cloudformation.model.StackSetDriftDetectionStatus =
      software.amazon.awssdk.services.cloudformation.model.StackSetDriftDetectionStatus.UNKNOWN_TO_SDK_VERSION
  }
  case object COMPLETED
      extends zio.aws.cloudformation.model.StackSetDriftDetectionStatus {
    override def unwrap
        : software.amazon.awssdk.services.cloudformation.model.StackSetDriftDetectionStatus =
      software.amazon.awssdk.services.cloudformation.model.StackSetDriftDetectionStatus.COMPLETED
  }
  case object FAILED
      extends zio.aws.cloudformation.model.StackSetDriftDetectionStatus {
    override def unwrap
        : software.amazon.awssdk.services.cloudformation.model.StackSetDriftDetectionStatus =
      software.amazon.awssdk.services.cloudformation.model.StackSetDriftDetectionStatus.FAILED
  }
  case object PARTIAL_SUCCESS
      extends zio.aws.cloudformation.model.StackSetDriftDetectionStatus {
    override def unwrap
        : software.amazon.awssdk.services.cloudformation.model.StackSetDriftDetectionStatus =
      software.amazon.awssdk.services.cloudformation.model.StackSetDriftDetectionStatus.PARTIAL_SUCCESS
  }
  case object IN_PROGRESS
      extends zio.aws.cloudformation.model.StackSetDriftDetectionStatus {
    override def unwrap
        : software.amazon.awssdk.services.cloudformation.model.StackSetDriftDetectionStatus =
      software.amazon.awssdk.services.cloudformation.model.StackSetDriftDetectionStatus.IN_PROGRESS
  }
  case object STOPPED
      extends zio.aws.cloudformation.model.StackSetDriftDetectionStatus {
    override def unwrap
        : software.amazon.awssdk.services.cloudformation.model.StackSetDriftDetectionStatus =
      software.amazon.awssdk.services.cloudformation.model.StackSetDriftDetectionStatus.STOPPED
  }
}
