package zio.aws.cloudformation.model
import zio.aws.cloudformation.model.primitives.{
  ParameterKey,
  ParameterValue,
  NoEcho,
  Description,
  ParameterType
}
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters._
final case class ParameterDeclaration(
    parameterKey: Option[ParameterKey] = None,
    defaultValue: Option[ParameterValue] = None,
    parameterType: Option[ParameterType] = None,
    noEcho: Option[NoEcho] = None,
    description: Option[Description] = None,
    parameterConstraints: Option[
      zio.aws.cloudformation.model.ParameterConstraints
    ] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.cloudformation.model.ParameterDeclaration = {
    import ParameterDeclaration.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.cloudformation.model.ParameterDeclaration
      .builder()
      .optionallyWith(
        parameterKey.map(value => ParameterKey.unwrap(value): java.lang.String)
      )(_.parameterKey)
      .optionallyWith(
        defaultValue.map(value =>
          ParameterValue.unwrap(value): java.lang.String
        )
      )(_.defaultValue)
      .optionallyWith(
        parameterType.map(value =>
          ParameterType.unwrap(value): java.lang.String
        )
      )(_.parameterType)
      .optionallyWith(
        noEcho.map(value => NoEcho.unwrap(value): java.lang.Boolean)
      )(_.noEcho)
      .optionallyWith(
        description.map(value => Description.unwrap(value): java.lang.String)
      )(_.description)
      .optionallyWith(parameterConstraints.map(value => value.buildAwsValue()))(
        _.parameterConstraints
      )
      .build()
  }
  def asReadOnly: zio.aws.cloudformation.model.ParameterDeclaration.ReadOnly =
    zio.aws.cloudformation.model.ParameterDeclaration.wrap(buildAwsValue())
}
object ParameterDeclaration {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.cloudformation.model.ParameterDeclaration
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.cloudformation.model.ParameterDeclaration =
      zio.aws.cloudformation.model.ParameterDeclaration(
        parameterKey.map(value => value),
        defaultValue.map(value => value),
        parameterType.map(value => value),
        noEcho.map(value => value),
        description.map(value => value),
        parameterConstraints.map(value => value.asEditable)
      )
    def parameterKey: Option[ParameterKey]
    def defaultValue: Option[ParameterValue]
    def parameterType: Option[ParameterType]
    def noEcho: Option[NoEcho]
    def description: Option[Description]
    def parameterConstraints
        : Option[zio.aws.cloudformation.model.ParameterConstraints.ReadOnly]
    def getParameterKey: ZIO[Any, AwsError, ParameterKey] =
      AwsError.unwrapOptionField("parameterKey", parameterKey)
    def getDefaultValue: ZIO[Any, AwsError, ParameterValue] =
      AwsError.unwrapOptionField("defaultValue", defaultValue)
    def getParameterType: ZIO[Any, AwsError, ParameterType] =
      AwsError.unwrapOptionField("parameterType", parameterType)
    def getNoEcho: ZIO[Any, AwsError, NoEcho] =
      AwsError.unwrapOptionField("noEcho", noEcho)
    def getDescription: ZIO[Any, AwsError, Description] =
      AwsError.unwrapOptionField("description", description)
    def getParameterConstraints: ZIO[
      Any,
      AwsError,
      zio.aws.cloudformation.model.ParameterConstraints.ReadOnly
    ] = AwsError.unwrapOptionField("parameterConstraints", parameterConstraints)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.cloudformation.model.ParameterDeclaration
  ) extends zio.aws.cloudformation.model.ParameterDeclaration.ReadOnly {
    override val parameterKey: Option[ParameterKey] = scala
      .Option(impl.parameterKey())
      .map(value => zio.aws.cloudformation.model.primitives.ParameterKey(value))
    override val defaultValue: Option[ParameterValue] = scala
      .Option(impl.defaultValue())
      .map(value =>
        zio.aws.cloudformation.model.primitives.ParameterValue(value)
      )
    override val parameterType: Option[ParameterType] = scala
      .Option(impl.parameterType())
      .map(value =>
        zio.aws.cloudformation.model.primitives.ParameterType(value)
      )
    override val noEcho: Option[NoEcho] = scala
      .Option(impl.noEcho())
      .map(value => zio.aws.cloudformation.model.primitives.NoEcho(value))
    override val description: Option[Description] = scala
      .Option(impl.description())
      .map(value => zio.aws.cloudformation.model.primitives.Description(value))
    override val parameterConstraints
        : Option[zio.aws.cloudformation.model.ParameterConstraints.ReadOnly] =
      scala
        .Option(impl.parameterConstraints())
        .map(value =>
          zio.aws.cloudformation.model.ParameterConstraints.wrap(value)
        )
  }
  def wrap(
      impl: software.amazon.awssdk.services.cloudformation.model.ParameterDeclaration
  ): zio.aws.cloudformation.model.ParameterDeclaration.ReadOnly = new Wrapper(
    impl
  )
}
