package zio.aws.cloudformation.model
import zio.aws.cloudformation.model.primitives.NextToken
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters._
final case class ListStacksRequest(
    nextToken: Option[NextToken] = None,
    stackStatusFilters: Option[
      Iterable[zio.aws.cloudformation.model.StackStatus]
    ] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.cloudformation.model.ListStacksRequest = {
    import ListStacksRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.cloudformation.model.ListStacksRequest
      .builder()
      .optionallyWith(
        nextToken.map(value => NextToken.unwrap(value): java.lang.String)
      )(_.nextToken)
      .optionallyWith(
        stackStatusFilters.map(value =>
          value.map { item =>
            item.unwrap.toString
          }.asJavaCollection
        )
      )(_.stackStatusFiltersWithStrings)
      .build()
  }
  def asReadOnly: zio.aws.cloudformation.model.ListStacksRequest.ReadOnly =
    zio.aws.cloudformation.model.ListStacksRequest.wrap(buildAwsValue())
}
object ListStacksRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.cloudformation.model.ListStacksRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.cloudformation.model.ListStacksRequest =
      zio.aws.cloudformation.model.ListStacksRequest(
        nextToken.map(value => value),
        stackStatusFilters.map(value => value)
      )
    def nextToken: Option[NextToken]
    def stackStatusFilters
        : Option[List[zio.aws.cloudformation.model.StackStatus]]
    def getNextToken: ZIO[Any, AwsError, NextToken] =
      AwsError.unwrapOptionField("nextToken", nextToken)
    def getStackStatusFilters
        : ZIO[Any, AwsError, List[zio.aws.cloudformation.model.StackStatus]] =
      AwsError.unwrapOptionField("stackStatusFilters", stackStatusFilters)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.cloudformation.model.ListStacksRequest
  ) extends zio.aws.cloudformation.model.ListStacksRequest.ReadOnly {
    override val nextToken: Option[NextToken] = scala
      .Option(impl.nextToken())
      .map(value => zio.aws.cloudformation.model.primitives.NextToken(value))
    override val stackStatusFilters
        : Option[List[zio.aws.cloudformation.model.StackStatus]] = scala
      .Option(impl.stackStatusFilters())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.cloudformation.model.StackStatus.wrap(item)
        }.toList
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.cloudformation.model.ListStacksRequest
  ): zio.aws.cloudformation.model.ListStacksRequest.ReadOnly = new Wrapper(impl)
}
