package zio.aws.cloudformation.model
import zio.aws.cloudformation.model.primitives.{NextToken, ExportName}
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters._
final case class ListImportsRequest(
    exportName: ExportName,
    nextToken: Option[NextToken] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.cloudformation.model.ListImportsRequest = {
    import ListImportsRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.cloudformation.model.ListImportsRequest
      .builder()
      .exportName(ExportName.unwrap(exportName): java.lang.String)
      .optionallyWith(
        nextToken.map(value => NextToken.unwrap(value): java.lang.String)
      )(_.nextToken)
      .build()
  }
  def asReadOnly: zio.aws.cloudformation.model.ListImportsRequest.ReadOnly =
    zio.aws.cloudformation.model.ListImportsRequest.wrap(buildAwsValue())
}
object ListImportsRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.cloudformation.model.ListImportsRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.cloudformation.model.ListImportsRequest =
      zio.aws.cloudformation.model
        .ListImportsRequest(exportName, nextToken.map(value => value))
    def exportName: ExportName
    def nextToken: Option[NextToken]
    def getExportName: ZIO[Any, Nothing, ExportName] = ZIO.succeed(exportName)
    def getNextToken: ZIO[Any, AwsError, NextToken] =
      AwsError.unwrapOptionField("nextToken", nextToken)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.cloudformation.model.ListImportsRequest
  ) extends zio.aws.cloudformation.model.ListImportsRequest.ReadOnly {
    override val exportName: ExportName =
      zio.aws.cloudformation.model.primitives.ExportName(impl.exportName())
    override val nextToken: Option[NextToken] = scala
      .Option(impl.nextToken())
      .map(value => zio.aws.cloudformation.model.primitives.NextToken(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.cloudformation.model.ListImportsRequest
  ): zio.aws.cloudformation.model.ListImportsRequest.ReadOnly = new Wrapper(
    impl
  )
}
