package zio.aws.cloudformation.model
import zio.aws.cloudformation.model.primitives.{ErrorMessage, ErrorCode}
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters._
final case class BatchDescribeTypeConfigurationsError(
    errorCode: Option[ErrorCode] = None,
    errorMessage: Option[ErrorMessage] = None,
    typeConfigurationIdentifier: Option[
      zio.aws.cloudformation.model.TypeConfigurationIdentifier
    ] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.cloudformation.model.BatchDescribeTypeConfigurationsError = {
    import BatchDescribeTypeConfigurationsError.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.cloudformation.model.BatchDescribeTypeConfigurationsError
      .builder()
      .optionallyWith(
        errorCode.map(value => ErrorCode.unwrap(value): java.lang.String)
      )(_.errorCode)
      .optionallyWith(
        errorMessage.map(value => ErrorMessage.unwrap(value): java.lang.String)
      )(_.errorMessage)
      .optionallyWith(
        typeConfigurationIdentifier.map(value => value.buildAwsValue())
      )(_.typeConfigurationIdentifier)
      .build()
  }
  def asReadOnly
      : zio.aws.cloudformation.model.BatchDescribeTypeConfigurationsError.ReadOnly =
    zio.aws.cloudformation.model.BatchDescribeTypeConfigurationsError
      .wrap(buildAwsValue())
}
object BatchDescribeTypeConfigurationsError {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.cloudformation.model.BatchDescribeTypeConfigurationsError
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.cloudformation.model.BatchDescribeTypeConfigurationsError =
      zio.aws.cloudformation.model.BatchDescribeTypeConfigurationsError(
        errorCode.map(value => value),
        errorMessage.map(value => value),
        typeConfigurationIdentifier.map(value => value.asEditable)
      )
    def errorCode: Option[ErrorCode]
    def errorMessage: Option[ErrorMessage]
    def typeConfigurationIdentifier: Option[
      zio.aws.cloudformation.model.TypeConfigurationIdentifier.ReadOnly
    ]
    def getErrorCode: ZIO[Any, AwsError, ErrorCode] =
      AwsError.unwrapOptionField("errorCode", errorCode)
    def getErrorMessage: ZIO[Any, AwsError, ErrorMessage] =
      AwsError.unwrapOptionField("errorMessage", errorMessage)
    def getTypeConfigurationIdentifier: ZIO[
      Any,
      AwsError,
      zio.aws.cloudformation.model.TypeConfigurationIdentifier.ReadOnly
    ] = AwsError.unwrapOptionField(
      "typeConfigurationIdentifier",
      typeConfigurationIdentifier
    )
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.cloudformation.model.BatchDescribeTypeConfigurationsError
  ) extends zio.aws.cloudformation.model.BatchDescribeTypeConfigurationsError.ReadOnly {
    override val errorCode: Option[ErrorCode] = scala
      .Option(impl.errorCode())
      .map(value => zio.aws.cloudformation.model.primitives.ErrorCode(value))
    override val errorMessage: Option[ErrorMessage] = scala
      .Option(impl.errorMessage())
      .map(value => zio.aws.cloudformation.model.primitives.ErrorMessage(value))
    override val typeConfigurationIdentifier: Option[
      zio.aws.cloudformation.model.TypeConfigurationIdentifier.ReadOnly
    ] = scala
      .Option(impl.typeConfigurationIdentifier())
      .map(value =>
        zio.aws.cloudformation.model.TypeConfigurationIdentifier.wrap(value)
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.cloudformation.model.BatchDescribeTypeConfigurationsError
  ): zio.aws.cloudformation.model.BatchDescribeTypeConfigurationsError.ReadOnly =
    new Wrapper(impl)
}
