package zio.aws.cloudformation.model
import zio.aws.cloudformation.model.primitives.RegistrationToken
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters._
final case class RegisterTypeResponse(
    registrationToken: Option[RegistrationToken] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.cloudformation.model.RegisterTypeResponse = {
    import RegisterTypeResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.cloudformation.model.RegisterTypeResponse
      .builder()
      .optionallyWith(
        registrationToken.map(value =>
          RegistrationToken.unwrap(value): java.lang.String
        )
      )(_.registrationToken)
      .build()
  }
  def asReadOnly: zio.aws.cloudformation.model.RegisterTypeResponse.ReadOnly =
    zio.aws.cloudformation.model.RegisterTypeResponse.wrap(buildAwsValue())
}
object RegisterTypeResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.cloudformation.model.RegisterTypeResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.cloudformation.model.RegisterTypeResponse =
      zio.aws.cloudformation.model
        .RegisterTypeResponse(registrationToken.map(value => value))
    def registrationToken: Option[RegistrationToken]
    def getRegistrationToken: ZIO[Any, AwsError, RegistrationToken] =
      AwsError.unwrapOptionField("registrationToken", registrationToken)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.cloudformation.model.RegisterTypeResponse
  ) extends zio.aws.cloudformation.model.RegisterTypeResponse.ReadOnly {
    override val registrationToken: Option[RegistrationToken] = scala
      .Option(impl.registrationToken())
      .map(value =>
        zio.aws.cloudformation.model.primitives.RegistrationToken(value)
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.cloudformation.model.RegisterTypeResponse
  ): zio.aws.cloudformation.model.RegisterTypeResponse.ReadOnly = new Wrapper(
    impl
  )
}
