package zio.aws.cloudformation.model
import zio.aws.cloudformation.model.primitives.{LogGroupName, RoleArn}
import zio.ZIO
import zio.aws.core.BuilderHelper
import scala.jdk.CollectionConverters._
final case class LoggingConfig(
    logRoleArn: RoleArn,
    logGroupName: LogGroupName
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.cloudformation.model.LoggingConfig = {
    import LoggingConfig.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.cloudformation.model.LoggingConfig
      .builder()
      .logRoleArn(RoleArn.unwrap(logRoleArn): java.lang.String)
      .logGroupName(LogGroupName.unwrap(logGroupName): java.lang.String)
      .build()
  }
  def asReadOnly: zio.aws.cloudformation.model.LoggingConfig.ReadOnly =
    zio.aws.cloudformation.model.LoggingConfig.wrap(buildAwsValue())
}
object LoggingConfig {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.cloudformation.model.LoggingConfig
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.cloudformation.model.LoggingConfig =
      zio.aws.cloudformation.model.LoggingConfig(logRoleArn, logGroupName)
    def logRoleArn: RoleArn
    def logGroupName: LogGroupName
    def getLogRoleArn: ZIO[Any, Nothing, RoleArn] = ZIO.succeed(logRoleArn)
    def getLogGroupName: ZIO[Any, Nothing, LogGroupName] =
      ZIO.succeed(logGroupName)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.cloudformation.model.LoggingConfig
  ) extends zio.aws.cloudformation.model.LoggingConfig.ReadOnly {
    override val logRoleArn: RoleArn =
      zio.aws.cloudformation.model.primitives.RoleArn(impl.logRoleArn())
    override val logGroupName: LogGroupName =
      zio.aws.cloudformation.model.primitives.LogGroupName(impl.logGroupName())
  }
  def wrap(
      impl: software.amazon.awssdk.services.cloudformation.model.LoggingConfig
  ): zio.aws.cloudformation.model.LoggingConfig.ReadOnly = new Wrapper(impl)
}
