package zio.aws.cloudformation.model
import java.lang.Integer
import zio.aws.cloudformation.model.primitives.{
  NextToken,
  MaxResults,
  TypeArn,
  TypeName
}
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters._
final case class ListTypeRegistrationsRequest(
    `type`: Option[zio.aws.cloudformation.model.RegistryType] = None,
    typeName: Option[TypeName] = None,
    typeArn: Option[TypeArn] = None,
    registrationStatusFilter: Option[
      zio.aws.cloudformation.model.RegistrationStatus
    ] = None,
    maxResults: Option[MaxResults] = None,
    nextToken: Option[NextToken] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.cloudformation.model.ListTypeRegistrationsRequest = {
    import ListTypeRegistrationsRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.cloudformation.model.ListTypeRegistrationsRequest
      .builder()
      .optionallyWith(`type`.map(value => value.unwrap))(_.`type`)
      .optionallyWith(
        typeName.map(value => TypeName.unwrap(value): java.lang.String)
      )(_.typeName)
      .optionallyWith(
        typeArn.map(value => TypeArn.unwrap(value): java.lang.String)
      )(_.typeArn)
      .optionallyWith(registrationStatusFilter.map(value => value.unwrap))(
        _.registrationStatusFilter
      )
      .optionallyWith(
        maxResults.map(value => MaxResults.unwrap(value): Integer)
      )(_.maxResults)
      .optionallyWith(
        nextToken.map(value => NextToken.unwrap(value): java.lang.String)
      )(_.nextToken)
      .build()
  }
  def asReadOnly
      : zio.aws.cloudformation.model.ListTypeRegistrationsRequest.ReadOnly =
    zio.aws.cloudformation.model.ListTypeRegistrationsRequest
      .wrap(buildAwsValue())
}
object ListTypeRegistrationsRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.cloudformation.model.ListTypeRegistrationsRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.cloudformation.model.ListTypeRegistrationsRequest =
      zio.aws.cloudformation.model.ListTypeRegistrationsRequest(
        `type`.map(value => value),
        typeName.map(value => value),
        typeArn.map(value => value),
        registrationStatusFilter.map(value => value),
        maxResults.map(value => value),
        nextToken.map(value => value)
      )
    def `type`: Option[zio.aws.cloudformation.model.RegistryType]
    def typeName: Option[TypeName]
    def typeArn: Option[TypeArn]
    def registrationStatusFilter
        : Option[zio.aws.cloudformation.model.RegistrationStatus]
    def maxResults: Option[MaxResults]
    def nextToken: Option[NextToken]
    def getType: ZIO[Any, AwsError, zio.aws.cloudformation.model.RegistryType] =
      AwsError.unwrapOptionField("type", `type`)
    def getTypeName: ZIO[Any, AwsError, TypeName] =
      AwsError.unwrapOptionField("typeName", typeName)
    def getTypeArn: ZIO[Any, AwsError, TypeArn] =
      AwsError.unwrapOptionField("typeArn", typeArn)
    def getRegistrationStatusFilter
        : ZIO[Any, AwsError, zio.aws.cloudformation.model.RegistrationStatus] =
      AwsError.unwrapOptionField(
        "registrationStatusFilter",
        registrationStatusFilter
      )
    def getMaxResults: ZIO[Any, AwsError, MaxResults] =
      AwsError.unwrapOptionField("maxResults", maxResults)
    def getNextToken: ZIO[Any, AwsError, NextToken] =
      AwsError.unwrapOptionField("nextToken", nextToken)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.cloudformation.model.ListTypeRegistrationsRequest
  ) extends zio.aws.cloudformation.model.ListTypeRegistrationsRequest.ReadOnly {
    override val `type`: Option[zio.aws.cloudformation.model.RegistryType] =
      scala
        .Option(impl.`type`())
        .map(value => zio.aws.cloudformation.model.RegistryType.wrap(value))
    override val typeName: Option[TypeName] = scala
      .Option(impl.typeName())
      .map(value => zio.aws.cloudformation.model.primitives.TypeName(value))
    override val typeArn: Option[TypeArn] = scala
      .Option(impl.typeArn())
      .map(value => zio.aws.cloudformation.model.primitives.TypeArn(value))
    override val registrationStatusFilter
        : Option[zio.aws.cloudformation.model.RegistrationStatus] = scala
      .Option(impl.registrationStatusFilter())
      .map(value => zio.aws.cloudformation.model.RegistrationStatus.wrap(value))
    override val maxResults: Option[MaxResults] = scala
      .Option(impl.maxResults())
      .map(value => zio.aws.cloudformation.model.primitives.MaxResults(value))
    override val nextToken: Option[NextToken] = scala
      .Option(impl.nextToken())
      .map(value => zio.aws.cloudformation.model.primitives.NextToken(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.cloudformation.model.ListTypeRegistrationsRequest
  ): zio.aws.cloudformation.model.ListTypeRegistrationsRequest.ReadOnly =
    new Wrapper(impl)
}
