package zio.aws.cloudformation.model
import zio.aws.cloudformation.model.primitives.NextToken
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters._
final case class ListStackInstancesResponse(
    summaries: Option[
      Iterable[zio.aws.cloudformation.model.StackInstanceSummary]
    ] = None,
    nextToken: Option[NextToken] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.cloudformation.model.ListStackInstancesResponse = {
    import ListStackInstancesResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.cloudformation.model.ListStackInstancesResponse
      .builder()
      .optionallyWith(
        summaries.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.summaries)
      .optionallyWith(
        nextToken.map(value => NextToken.unwrap(value): java.lang.String)
      )(_.nextToken)
      .build()
  }
  def asReadOnly
      : zio.aws.cloudformation.model.ListStackInstancesResponse.ReadOnly =
    zio.aws.cloudformation.model.ListStackInstancesResponse
      .wrap(buildAwsValue())
}
object ListStackInstancesResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.cloudformation.model.ListStackInstancesResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.cloudformation.model.ListStackInstancesResponse =
      zio.aws.cloudformation.model.ListStackInstancesResponse(
        summaries.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        nextToken.map(value => value)
      )
    def summaries: Option[
      List[zio.aws.cloudformation.model.StackInstanceSummary.ReadOnly]
    ]
    def nextToken: Option[NextToken]
    def getSummaries: ZIO[Any, AwsError, List[
      zio.aws.cloudformation.model.StackInstanceSummary.ReadOnly
    ]] = AwsError.unwrapOptionField("summaries", summaries)
    def getNextToken: ZIO[Any, AwsError, NextToken] =
      AwsError.unwrapOptionField("nextToken", nextToken)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.cloudformation.model.ListStackInstancesResponse
  ) extends zio.aws.cloudformation.model.ListStackInstancesResponse.ReadOnly {
    override val summaries: Option[
      List[zio.aws.cloudformation.model.StackInstanceSummary.ReadOnly]
    ] = scala
      .Option(impl.summaries())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.cloudformation.model.StackInstanceSummary.wrap(item)
        }.toList
      )
    override val nextToken: Option[NextToken] = scala
      .Option(impl.nextToken())
      .map(value => zio.aws.cloudformation.model.primitives.NextToken(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.cloudformation.model.ListStackInstancesResponse
  ): zio.aws.cloudformation.model.ListStackInstancesResponse.ReadOnly =
    new Wrapper(impl)
}
