package zio.aws.cloudformation.model
import zio.aws.cloudformation.model.primitives.NextToken
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters._
final case class DescribeAccountLimitsResponse(
    accountLimits: Option[Iterable[zio.aws.cloudformation.model.AccountLimit]] =
      None,
    nextToken: Option[NextToken] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.cloudformation.model.DescribeAccountLimitsResponse = {
    import DescribeAccountLimitsResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.cloudformation.model.DescribeAccountLimitsResponse
      .builder()
      .optionallyWith(
        accountLimits.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.accountLimits)
      .optionallyWith(
        nextToken.map(value => NextToken.unwrap(value): java.lang.String)
      )(_.nextToken)
      .build()
  }
  def asReadOnly
      : zio.aws.cloudformation.model.DescribeAccountLimitsResponse.ReadOnly =
    zio.aws.cloudformation.model.DescribeAccountLimitsResponse
      .wrap(buildAwsValue())
}
object DescribeAccountLimitsResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.cloudformation.model.DescribeAccountLimitsResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.cloudformation.model.DescribeAccountLimitsResponse =
      zio.aws.cloudformation.model.DescribeAccountLimitsResponse(
        accountLimits.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        nextToken.map(value => value)
      )
    def accountLimits
        : Option[List[zio.aws.cloudformation.model.AccountLimit.ReadOnly]]
    def nextToken: Option[NextToken]
    def getAccountLimits: ZIO[Any, AwsError, List[
      zio.aws.cloudformation.model.AccountLimit.ReadOnly
    ]] = AwsError.unwrapOptionField("accountLimits", accountLimits)
    def getNextToken: ZIO[Any, AwsError, NextToken] =
      AwsError.unwrapOptionField("nextToken", nextToken)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.cloudformation.model.DescribeAccountLimitsResponse
  ) extends zio.aws.cloudformation.model.DescribeAccountLimitsResponse.ReadOnly {
    override val accountLimits
        : Option[List[zio.aws.cloudformation.model.AccountLimit.ReadOnly]] =
      scala
        .Option(impl.accountLimits())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.cloudformation.model.AccountLimit.wrap(item)
          }.toList
        )
    override val nextToken: Option[NextToken] = scala
      .Option(impl.nextToken())
      .map(value => zio.aws.cloudformation.model.primitives.NextToken(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.cloudformation.model.DescribeAccountLimitsResponse
  ): zio.aws.cloudformation.model.DescribeAccountLimitsResponse.ReadOnly =
    new Wrapper(impl)
}
