package zio.aws.cloudformation.model
import zio.aws.cloudformation.model.primitives.PrivateTypeArn
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters._
final case class ActivateTypeResponse(arn: Option[PrivateTypeArn] = None) {
  def buildAwsValue()
      : software.amazon.awssdk.services.cloudformation.model.ActivateTypeResponse = {
    import ActivateTypeResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.cloudformation.model.ActivateTypeResponse
      .builder()
      .optionallyWith(
        arn.map(value => PrivateTypeArn.unwrap(value): java.lang.String)
      )(_.arn)
      .build()
  }
  def asReadOnly: zio.aws.cloudformation.model.ActivateTypeResponse.ReadOnly =
    zio.aws.cloudformation.model.ActivateTypeResponse.wrap(buildAwsValue())
}
object ActivateTypeResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.cloudformation.model.ActivateTypeResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.cloudformation.model.ActivateTypeResponse =
      zio.aws.cloudformation.model.ActivateTypeResponse(arn.map(value => value))
    def arn: Option[PrivateTypeArn]
    def getArn: ZIO[Any, AwsError, PrivateTypeArn] =
      AwsError.unwrapOptionField("arn", arn)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.cloudformation.model.ActivateTypeResponse
  ) extends zio.aws.cloudformation.model.ActivateTypeResponse.ReadOnly {
    override val arn: Option[PrivateTypeArn] = scala
      .Option(impl.arn())
      .map(value =>
        zio.aws.cloudformation.model.primitives.PrivateTypeArn(value)
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.cloudformation.model.ActivateTypeResponse
  ): zio.aws.cloudformation.model.ActivateTypeResponse.ReadOnly = new Wrapper(
    impl
  )
}
