package zio.aws.cloudformation.model
import zio.aws.cloudformation.model.primitives.ClientRequestToken
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters._
final case class UpdateStackInstancesResponse(
    operationId: Option[ClientRequestToken] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.cloudformation.model.UpdateStackInstancesResponse = {
    import UpdateStackInstancesResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.cloudformation.model.UpdateStackInstancesResponse
      .builder()
      .optionallyWith(
        operationId.map(value =>
          ClientRequestToken.unwrap(value): java.lang.String
        )
      )(_.operationId)
      .build()
  }
  def asReadOnly
      : zio.aws.cloudformation.model.UpdateStackInstancesResponse.ReadOnly =
    zio.aws.cloudformation.model.UpdateStackInstancesResponse
      .wrap(buildAwsValue())
}
object UpdateStackInstancesResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.cloudformation.model.UpdateStackInstancesResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.cloudformation.model.UpdateStackInstancesResponse =
      zio.aws.cloudformation.model
        .UpdateStackInstancesResponse(operationId.map(value => value))
    def operationId: Option[ClientRequestToken]
    def getOperationId: ZIO[Any, AwsError, ClientRequestToken] =
      AwsError.unwrapOptionField("operationId", operationId)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.cloudformation.model.UpdateStackInstancesResponse
  ) extends zio.aws.cloudformation.model.UpdateStackInstancesResponse.ReadOnly {
    override val operationId: Option[ClientRequestToken] = scala
      .Option(impl.operationId())
      .map(value =>
        zio.aws.cloudformation.model.primitives.ClientRequestToken(value)
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.cloudformation.model.UpdateStackInstancesResponse
  ): zio.aws.cloudformation.model.UpdateStackInstancesResponse.ReadOnly =
    new Wrapper(impl)
}
