package zio.aws.cloudformation.model
import zio.aws.cloudformation.model.primitives.{
  LogicalResourceId,
  StackName,
  ResourceProperties,
  Timestamp,
  ClientRequestToken,
  EventId,
  StackId,
  ResourceStatusReason,
  PhysicalResourceId,
  ResourceType
}
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import java.time.Instant
import scala.jdk.CollectionConverters._
final case class StackEvent(
    stackId: StackId,
    eventId: EventId,
    stackName: StackName,
    logicalResourceId: Option[LogicalResourceId] = None,
    physicalResourceId: Option[PhysicalResourceId] = None,
    resourceType: Option[ResourceType] = None,
    timestamp: Timestamp,
    resourceStatus: Option[zio.aws.cloudformation.model.ResourceStatus] = None,
    resourceStatusReason: Option[ResourceStatusReason] = None,
    resourceProperties: Option[ResourceProperties] = None,
    clientRequestToken: Option[ClientRequestToken] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.cloudformation.model.StackEvent = {
    import StackEvent.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.cloudformation.model.StackEvent
      .builder()
      .stackId(StackId.unwrap(stackId): java.lang.String)
      .eventId(EventId.unwrap(eventId): java.lang.String)
      .stackName(StackName.unwrap(stackName): java.lang.String)
      .optionallyWith(
        logicalResourceId.map(value =>
          LogicalResourceId.unwrap(value): java.lang.String
        )
      )(_.logicalResourceId)
      .optionallyWith(
        physicalResourceId.map(value =>
          PhysicalResourceId.unwrap(value): java.lang.String
        )
      )(_.physicalResourceId)
      .optionallyWith(
        resourceType.map(value => ResourceType.unwrap(value): java.lang.String)
      )(_.resourceType)
      .timestamp(Timestamp.unwrap(timestamp): Instant)
      .optionallyWith(resourceStatus.map(value => value.unwrap))(
        _.resourceStatus
      )
      .optionallyWith(
        resourceStatusReason.map(value =>
          ResourceStatusReason.unwrap(value): java.lang.String
        )
      )(_.resourceStatusReason)
      .optionallyWith(
        resourceProperties.map(value =>
          ResourceProperties.unwrap(value): java.lang.String
        )
      )(_.resourceProperties)
      .optionallyWith(
        clientRequestToken.map(value =>
          ClientRequestToken.unwrap(value): java.lang.String
        )
      )(_.clientRequestToken)
      .build()
  }
  def asReadOnly: zio.aws.cloudformation.model.StackEvent.ReadOnly =
    zio.aws.cloudformation.model.StackEvent.wrap(buildAwsValue())
}
object StackEvent {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.cloudformation.model.StackEvent
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.cloudformation.model.StackEvent =
      zio.aws.cloudformation.model.StackEvent(
        stackId,
        eventId,
        stackName,
        logicalResourceId.map(value => value),
        physicalResourceId.map(value => value),
        resourceType.map(value => value),
        timestamp,
        resourceStatus.map(value => value),
        resourceStatusReason.map(value => value),
        resourceProperties.map(value => value),
        clientRequestToken.map(value => value)
      )
    def stackId: StackId
    def eventId: EventId
    def stackName: StackName
    def logicalResourceId: Option[LogicalResourceId]
    def physicalResourceId: Option[PhysicalResourceId]
    def resourceType: Option[ResourceType]
    def timestamp: Timestamp
    def resourceStatus: Option[zio.aws.cloudformation.model.ResourceStatus]
    def resourceStatusReason: Option[ResourceStatusReason]
    def resourceProperties: Option[ResourceProperties]
    def clientRequestToken: Option[ClientRequestToken]
    def getStackId: ZIO[Any, Nothing, StackId] = ZIO.succeed(stackId)
    def getEventId: ZIO[Any, Nothing, EventId] = ZIO.succeed(eventId)
    def getStackName: ZIO[Any, Nothing, StackName] = ZIO.succeed(stackName)
    def getLogicalResourceId: ZIO[Any, AwsError, LogicalResourceId] =
      AwsError.unwrapOptionField("logicalResourceId", logicalResourceId)
    def getPhysicalResourceId: ZIO[Any, AwsError, PhysicalResourceId] =
      AwsError.unwrapOptionField("physicalResourceId", physicalResourceId)
    def getResourceType: ZIO[Any, AwsError, ResourceType] =
      AwsError.unwrapOptionField("resourceType", resourceType)
    def getTimestamp: ZIO[Any, Nothing, Timestamp] = ZIO.succeed(timestamp)
    def getResourceStatus
        : ZIO[Any, AwsError, zio.aws.cloudformation.model.ResourceStatus] =
      AwsError.unwrapOptionField("resourceStatus", resourceStatus)
    def getResourceStatusReason: ZIO[Any, AwsError, ResourceStatusReason] =
      AwsError.unwrapOptionField("resourceStatusReason", resourceStatusReason)
    def getResourceProperties: ZIO[Any, AwsError, ResourceProperties] =
      AwsError.unwrapOptionField("resourceProperties", resourceProperties)
    def getClientRequestToken: ZIO[Any, AwsError, ClientRequestToken] =
      AwsError.unwrapOptionField("clientRequestToken", clientRequestToken)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.cloudformation.model.StackEvent
  ) extends zio.aws.cloudformation.model.StackEvent.ReadOnly {
    override val stackId: StackId =
      zio.aws.cloudformation.model.primitives.StackId(impl.stackId())
    override val eventId: EventId =
      zio.aws.cloudformation.model.primitives.EventId(impl.eventId())
    override val stackName: StackName =
      zio.aws.cloudformation.model.primitives.StackName(impl.stackName())
    override val logicalResourceId: Option[LogicalResourceId] = scala
      .Option(impl.logicalResourceId())
      .map(value =>
        zio.aws.cloudformation.model.primitives.LogicalResourceId(value)
      )
    override val physicalResourceId: Option[PhysicalResourceId] = scala
      .Option(impl.physicalResourceId())
      .map(value =>
        zio.aws.cloudformation.model.primitives.PhysicalResourceId(value)
      )
    override val resourceType: Option[ResourceType] = scala
      .Option(impl.resourceType())
      .map(value => zio.aws.cloudformation.model.primitives.ResourceType(value))
    override val timestamp: Timestamp =
      zio.aws.cloudformation.model.primitives.Timestamp(impl.timestamp())
    override val resourceStatus
        : Option[zio.aws.cloudformation.model.ResourceStatus] = scala
      .Option(impl.resourceStatus())
      .map(value => zio.aws.cloudformation.model.ResourceStatus.wrap(value))
    override val resourceStatusReason: Option[ResourceStatusReason] = scala
      .Option(impl.resourceStatusReason())
      .map(value =>
        zio.aws.cloudformation.model.primitives.ResourceStatusReason(value)
      )
    override val resourceProperties: Option[ResourceProperties] = scala
      .Option(impl.resourceProperties())
      .map(value =>
        zio.aws.cloudformation.model.primitives.ResourceProperties(value)
      )
    override val clientRequestToken: Option[ClientRequestToken] = scala
      .Option(impl.clientRequestToken())
      .map(value =>
        zio.aws.cloudformation.model.primitives.ClientRequestToken(value)
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.cloudformation.model.StackEvent
  ): zio.aws.cloudformation.model.StackEvent.ReadOnly = new Wrapper(impl)
}
