package zio.aws.cloudformation.model
import scala.jdk.CollectionConverters._
sealed trait RegistrationStatus {
  def unwrap
      : software.amazon.awssdk.services.cloudformation.model.RegistrationStatus
}
object RegistrationStatus {
  def wrap(
      value: software.amazon.awssdk.services.cloudformation.model.RegistrationStatus
  ): zio.aws.cloudformation.model.RegistrationStatus = value match {
    case software.amazon.awssdk.services.cloudformation.model.RegistrationStatus.UNKNOWN_TO_SDK_VERSION =>
      val r = unknownToSdkVersion
      r
    case software.amazon.awssdk.services.cloudformation.model.RegistrationStatus.COMPLETE =>
      val r = COMPLETE
      r
    case software.amazon.awssdk.services.cloudformation.model.RegistrationStatus.IN_PROGRESS =>
      val r = IN_PROGRESS
      r
    case software.amazon.awssdk.services.cloudformation.model.RegistrationStatus.FAILED =>
      val r = FAILED
      r
  }
  case object unknownToSdkVersion
      extends zio.aws.cloudformation.model.RegistrationStatus {
    override def unwrap
        : software.amazon.awssdk.services.cloudformation.model.RegistrationStatus =
      software.amazon.awssdk.services.cloudformation.model.RegistrationStatus.UNKNOWN_TO_SDK_VERSION
  }
  case object COMPLETE extends zio.aws.cloudformation.model.RegistrationStatus {
    override def unwrap
        : software.amazon.awssdk.services.cloudformation.model.RegistrationStatus =
      software.amazon.awssdk.services.cloudformation.model.RegistrationStatus.COMPLETE
  }
  case object IN_PROGRESS
      extends zio.aws.cloudformation.model.RegistrationStatus {
    override def unwrap
        : software.amazon.awssdk.services.cloudformation.model.RegistrationStatus =
      software.amazon.awssdk.services.cloudformation.model.RegistrationStatus.IN_PROGRESS
  }
  case object FAILED extends zio.aws.cloudformation.model.RegistrationStatus {
    override def unwrap
        : software.amazon.awssdk.services.cloudformation.model.RegistrationStatus =
      software.amazon.awssdk.services.cloudformation.model.RegistrationStatus.FAILED
  }
}
