package zio.aws.cloudformation.model
import zio.aws.cloudformation.model.primitives.{
  ExportName,
  Description,
  OutputValue,
  OutputKey
}
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters._
final case class Output(
    outputKey: Option[OutputKey] = None,
    outputValue: Option[OutputValue] = None,
    description: Option[Description] = None,
    exportName: Option[ExportName] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.cloudformation.model.Output = {
    import Output.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.cloudformation.model.Output
      .builder()
      .optionallyWith(
        outputKey.map(value => OutputKey.unwrap(value): java.lang.String)
      )(_.outputKey)
      .optionallyWith(
        outputValue.map(value => OutputValue.unwrap(value): java.lang.String)
      )(_.outputValue)
      .optionallyWith(
        description.map(value => Description.unwrap(value): java.lang.String)
      )(_.description)
      .optionallyWith(
        exportName.map(value => ExportName.unwrap(value): java.lang.String)
      )(_.exportName)
      .build()
  }
  def asReadOnly: zio.aws.cloudformation.model.Output.ReadOnly =
    zio.aws.cloudformation.model.Output.wrap(buildAwsValue())
}
object Output {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.cloudformation.model.Output
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.cloudformation.model.Output =
      zio.aws.cloudformation.model.Output(
        outputKey.map(value => value),
        outputValue.map(value => value),
        description.map(value => value),
        exportName.map(value => value)
      )
    def outputKey: Option[OutputKey]
    def outputValue: Option[OutputValue]
    def description: Option[Description]
    def exportName: Option[ExportName]
    def getOutputKey: ZIO[Any, AwsError, OutputKey] =
      AwsError.unwrapOptionField("outputKey", outputKey)
    def getOutputValue: ZIO[Any, AwsError, OutputValue] =
      AwsError.unwrapOptionField("outputValue", outputValue)
    def getDescription: ZIO[Any, AwsError, Description] =
      AwsError.unwrapOptionField("description", description)
    def getExportName: ZIO[Any, AwsError, ExportName] =
      AwsError.unwrapOptionField("exportName", exportName)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.cloudformation.model.Output
  ) extends zio.aws.cloudformation.model.Output.ReadOnly {
    override val outputKey: Option[OutputKey] = scala
      .Option(impl.outputKey())
      .map(value => zio.aws.cloudformation.model.primitives.OutputKey(value))
    override val outputValue: Option[OutputValue] = scala
      .Option(impl.outputValue())
      .map(value => zio.aws.cloudformation.model.primitives.OutputValue(value))
    override val description: Option[Description] = scala
      .Option(impl.description())
      .map(value => zio.aws.cloudformation.model.primitives.Description(value))
    override val exportName: Option[ExportName] = scala
      .Option(impl.exportName())
      .map(value => zio.aws.cloudformation.model.primitives.ExportName(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.cloudformation.model.Output
  ): zio.aws.cloudformation.model.Output.ReadOnly = new Wrapper(impl)
}
