package zio.aws.cloudformation.model
import zio.aws.cloudformation.model.primitives.{
  NextToken,
  StackNameOrId,
  ChangeSetNameOrId
}
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters._
final case class DescribeChangeSetRequest(
    changeSetName: ChangeSetNameOrId,
    stackName: Option[StackNameOrId] = None,
    nextToken: Option[NextToken] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.cloudformation.model.DescribeChangeSetRequest = {
    import DescribeChangeSetRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.cloudformation.model.DescribeChangeSetRequest
      .builder()
      .changeSetName(ChangeSetNameOrId.unwrap(changeSetName): java.lang.String)
      .optionallyWith(
        stackName.map(value => StackNameOrId.unwrap(value): java.lang.String)
      )(_.stackName)
      .optionallyWith(
        nextToken.map(value => NextToken.unwrap(value): java.lang.String)
      )(_.nextToken)
      .build()
  }
  def asReadOnly
      : zio.aws.cloudformation.model.DescribeChangeSetRequest.ReadOnly =
    zio.aws.cloudformation.model.DescribeChangeSetRequest.wrap(buildAwsValue())
}
object DescribeChangeSetRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.cloudformation.model.DescribeChangeSetRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.cloudformation.model.DescribeChangeSetRequest =
      zio.aws.cloudformation.model.DescribeChangeSetRequest(
        changeSetName,
        stackName.map(value => value),
        nextToken.map(value => value)
      )
    def changeSetName: ChangeSetNameOrId
    def stackName: Option[StackNameOrId]
    def nextToken: Option[NextToken]
    def getChangeSetName: ZIO[Any, Nothing, ChangeSetNameOrId] =
      ZIO.succeed(changeSetName)
    def getStackName: ZIO[Any, AwsError, StackNameOrId] =
      AwsError.unwrapOptionField("stackName", stackName)
    def getNextToken: ZIO[Any, AwsError, NextToken] =
      AwsError.unwrapOptionField("nextToken", nextToken)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.cloudformation.model.DescribeChangeSetRequest
  ) extends zio.aws.cloudformation.model.DescribeChangeSetRequest.ReadOnly {
    override val changeSetName: ChangeSetNameOrId =
      zio.aws.cloudformation.model.primitives
        .ChangeSetNameOrId(impl.changeSetName())
    override val stackName: Option[StackNameOrId] = scala
      .Option(impl.stackName())
      .map(value =>
        zio.aws.cloudformation.model.primitives.StackNameOrId(value)
      )
    override val nextToken: Option[NextToken] = scala
      .Option(impl.nextToken())
      .map(value => zio.aws.cloudformation.model.primitives.NextToken(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.cloudformation.model.DescribeChangeSetRequest
  ): zio.aws.cloudformation.model.DescribeChangeSetRequest.ReadOnly =
    new Wrapper(impl)
}
