package zio.aws.cloudformation.model
import zio.aws.cloudformation.model.primitives.ClientRequestToken
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters._
final case class DeleteStackInstancesResponse(
    operationId: Option[ClientRequestToken] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.cloudformation.model.DeleteStackInstancesResponse = {
    import DeleteStackInstancesResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.cloudformation.model.DeleteStackInstancesResponse
      .builder()
      .optionallyWith(
        operationId.map(value =>
          ClientRequestToken.unwrap(value): java.lang.String
        )
      )(_.operationId)
      .build()
  }
  def asReadOnly
      : zio.aws.cloudformation.model.DeleteStackInstancesResponse.ReadOnly =
    zio.aws.cloudformation.model.DeleteStackInstancesResponse
      .wrap(buildAwsValue())
}
object DeleteStackInstancesResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.cloudformation.model.DeleteStackInstancesResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.cloudformation.model.DeleteStackInstancesResponse =
      zio.aws.cloudformation.model
        .DeleteStackInstancesResponse(operationId.map(value => value))
    def operationId: Option[ClientRequestToken]
    def getOperationId: ZIO[Any, AwsError, ClientRequestToken] =
      AwsError.unwrapOptionField("operationId", operationId)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.cloudformation.model.DeleteStackInstancesResponse
  ) extends zio.aws.cloudformation.model.DeleteStackInstancesResponse.ReadOnly {
    override val operationId: Option[ClientRequestToken] = scala
      .Option(impl.operationId())
      .map(value =>
        zio.aws.cloudformation.model.primitives.ClientRequestToken(value)
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.cloudformation.model.DeleteStackInstancesResponse
  ): zio.aws.cloudformation.model.DeleteStackInstancesResponse.ReadOnly =
    new Wrapper(impl)
}
