package zio.aws.cloudformation.model
import zio.aws.cloudformation.model.primitives.StackSetId
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters._
final case class CreateStackSetResponse(stackSetId: Option[StackSetId] = None) {
  def buildAwsValue()
      : software.amazon.awssdk.services.cloudformation.model.CreateStackSetResponse = {
    import CreateStackSetResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.cloudformation.model.CreateStackSetResponse
      .builder()
      .optionallyWith(
        stackSetId.map(value => StackSetId.unwrap(value): java.lang.String)
      )(_.stackSetId)
      .build()
  }
  def asReadOnly: zio.aws.cloudformation.model.CreateStackSetResponse.ReadOnly =
    zio.aws.cloudformation.model.CreateStackSetResponse.wrap(buildAwsValue())
}
object CreateStackSetResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.cloudformation.model.CreateStackSetResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.cloudformation.model.CreateStackSetResponse =
      zio.aws.cloudformation.model
        .CreateStackSetResponse(stackSetId.map(value => value))
    def stackSetId: Option[StackSetId]
    def getStackSetId: ZIO[Any, AwsError, StackSetId] =
      AwsError.unwrapOptionField("stackSetId", stackSetId)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.cloudformation.model.CreateStackSetResponse
  ) extends zio.aws.cloudformation.model.CreateStackSetResponse.ReadOnly {
    override val stackSetId: Option[StackSetId] = scala
      .Option(impl.stackSetId())
      .map(value => zio.aws.cloudformation.model.primitives.StackSetId(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.cloudformation.model.CreateStackSetResponse
  ): zio.aws.cloudformation.model.CreateStackSetResponse.ReadOnly = new Wrapper(
    impl
  )
}
