package zio.aws.cloudformation.model
import zio.aws.cloudformation.model.primitives.{
  PublisherId,
  RoleArn,
  ThirdPartyTypeArn,
  AutoUpdate,
  TypeName,
  MajorVersion
}
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters._
final case class ActivateTypeRequest(
    `type`: Option[zio.aws.cloudformation.model.ThirdPartyType] = None,
    publicTypeArn: Option[ThirdPartyTypeArn] = None,
    publisherId: Option[PublisherId] = None,
    typeName: Option[TypeName] = None,
    typeNameAlias: Option[TypeName] = None,
    autoUpdate: Option[AutoUpdate] = None,
    loggingConfig: Option[zio.aws.cloudformation.model.LoggingConfig] = None,
    executionRoleArn: Option[RoleArn] = None,
    versionBump: Option[zio.aws.cloudformation.model.VersionBump] = None,
    majorVersion: Option[MajorVersion] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.cloudformation.model.ActivateTypeRequest = {
    import ActivateTypeRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.cloudformation.model.ActivateTypeRequest
      .builder()
      .optionallyWith(`type`.map(value => value.unwrap))(_.`type`)
      .optionallyWith(
        publicTypeArn.map(value =>
          ThirdPartyTypeArn.unwrap(value): java.lang.String
        )
      )(_.publicTypeArn)
      .optionallyWith(
        publisherId.map(value => PublisherId.unwrap(value): java.lang.String)
      )(_.publisherId)
      .optionallyWith(
        typeName.map(value => TypeName.unwrap(value): java.lang.String)
      )(_.typeName)
      .optionallyWith(
        typeNameAlias.map(value => TypeName.unwrap(value): java.lang.String)
      )(_.typeNameAlias)
      .optionallyWith(
        autoUpdate.map(value => AutoUpdate.unwrap(value): java.lang.Boolean)
      )(_.autoUpdate)
      .optionallyWith(loggingConfig.map(value => value.buildAwsValue()))(
        _.loggingConfig
      )
      .optionallyWith(
        executionRoleArn.map(value => RoleArn.unwrap(value): java.lang.String)
      )(_.executionRoleArn)
      .optionallyWith(versionBump.map(value => value.unwrap))(_.versionBump)
      .optionallyWith(
        majorVersion.map(value => MajorVersion.unwrap(value): java.lang.Long)
      )(_.majorVersion)
      .build()
  }
  def asReadOnly: zio.aws.cloudformation.model.ActivateTypeRequest.ReadOnly =
    zio.aws.cloudformation.model.ActivateTypeRequest.wrap(buildAwsValue())
}
object ActivateTypeRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.cloudformation.model.ActivateTypeRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.cloudformation.model.ActivateTypeRequest =
      zio.aws.cloudformation.model.ActivateTypeRequest(
        `type`.map(value => value),
        publicTypeArn.map(value => value),
        publisherId.map(value => value),
        typeName.map(value => value),
        typeNameAlias.map(value => value),
        autoUpdate.map(value => value),
        loggingConfig.map(value => value.asEditable),
        executionRoleArn.map(value => value),
        versionBump.map(value => value),
        majorVersion.map(value => value)
      )
    def `type`: Option[zio.aws.cloudformation.model.ThirdPartyType]
    def publicTypeArn: Option[ThirdPartyTypeArn]
    def publisherId: Option[PublisherId]
    def typeName: Option[TypeName]
    def typeNameAlias: Option[TypeName]
    def autoUpdate: Option[AutoUpdate]
    def loggingConfig
        : Option[zio.aws.cloudformation.model.LoggingConfig.ReadOnly]
    def executionRoleArn: Option[RoleArn]
    def versionBump: Option[zio.aws.cloudformation.model.VersionBump]
    def majorVersion: Option[MajorVersion]
    def getType
        : ZIO[Any, AwsError, zio.aws.cloudformation.model.ThirdPartyType] =
      AwsError.unwrapOptionField("type", `type`)
    def getPublicTypeArn: ZIO[Any, AwsError, ThirdPartyTypeArn] =
      AwsError.unwrapOptionField("publicTypeArn", publicTypeArn)
    def getPublisherId: ZIO[Any, AwsError, PublisherId] =
      AwsError.unwrapOptionField("publisherId", publisherId)
    def getTypeName: ZIO[Any, AwsError, TypeName] =
      AwsError.unwrapOptionField("typeName", typeName)
    def getTypeNameAlias: ZIO[Any, AwsError, TypeName] =
      AwsError.unwrapOptionField("typeNameAlias", typeNameAlias)
    def getAutoUpdate: ZIO[Any, AwsError, AutoUpdate] =
      AwsError.unwrapOptionField("autoUpdate", autoUpdate)
    def getLoggingConfig: ZIO[
      Any,
      AwsError,
      zio.aws.cloudformation.model.LoggingConfig.ReadOnly
    ] = AwsError.unwrapOptionField("loggingConfig", loggingConfig)
    def getExecutionRoleArn: ZIO[Any, AwsError, RoleArn] =
      AwsError.unwrapOptionField("executionRoleArn", executionRoleArn)
    def getVersionBump
        : ZIO[Any, AwsError, zio.aws.cloudformation.model.VersionBump] =
      AwsError.unwrapOptionField("versionBump", versionBump)
    def getMajorVersion: ZIO[Any, AwsError, MajorVersion] =
      AwsError.unwrapOptionField("majorVersion", majorVersion)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.cloudformation.model.ActivateTypeRequest
  ) extends zio.aws.cloudformation.model.ActivateTypeRequest.ReadOnly {
    override val `type`: Option[zio.aws.cloudformation.model.ThirdPartyType] =
      scala
        .Option(impl.`type`())
        .map(value => zio.aws.cloudformation.model.ThirdPartyType.wrap(value))
    override val publicTypeArn: Option[ThirdPartyTypeArn] = scala
      .Option(impl.publicTypeArn())
      .map(value =>
        zio.aws.cloudformation.model.primitives.ThirdPartyTypeArn(value)
      )
    override val publisherId: Option[PublisherId] = scala
      .Option(impl.publisherId())
      .map(value => zio.aws.cloudformation.model.primitives.PublisherId(value))
    override val typeName: Option[TypeName] = scala
      .Option(impl.typeName())
      .map(value => zio.aws.cloudformation.model.primitives.TypeName(value))
    override val typeNameAlias: Option[TypeName] = scala
      .Option(impl.typeNameAlias())
      .map(value => zio.aws.cloudformation.model.primitives.TypeName(value))
    override val autoUpdate: Option[AutoUpdate] = scala
      .Option(impl.autoUpdate())
      .map(value => zio.aws.cloudformation.model.primitives.AutoUpdate(value))
    override val loggingConfig
        : Option[zio.aws.cloudformation.model.LoggingConfig.ReadOnly] = scala
      .Option(impl.loggingConfig())
      .map(value => zio.aws.cloudformation.model.LoggingConfig.wrap(value))
    override val executionRoleArn: Option[RoleArn] = scala
      .Option(impl.executionRoleArn())
      .map(value => zio.aws.cloudformation.model.primitives.RoleArn(value))
    override val versionBump: Option[zio.aws.cloudformation.model.VersionBump] =
      scala
        .Option(impl.versionBump())
        .map(value => zio.aws.cloudformation.model.VersionBump.wrap(value))
    override val majorVersion: Option[MajorVersion] = scala
      .Option(impl.majorVersion())
      .map(value => zio.aws.cloudformation.model.primitives.MajorVersion(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.cloudformation.model.ActivateTypeRequest
  ): zio.aws.cloudformation.model.ActivateTypeRequest.ReadOnly = new Wrapper(
    impl
  )
}
