package zio.aws.cloudformation.model
import zio.aws.cloudformation.model.primitives.StackId
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters._
final case class UpdateStackResponse(stackId: Option[StackId] = None) {
  def buildAwsValue()
      : software.amazon.awssdk.services.cloudformation.model.UpdateStackResponse = {
    import UpdateStackResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.cloudformation.model.UpdateStackResponse
      .builder()
      .optionallyWith(
        stackId.map(value => StackId.unwrap(value): java.lang.String)
      )(_.stackId)
      .build()
  }
  def asReadOnly: zio.aws.cloudformation.model.UpdateStackResponse.ReadOnly =
    zio.aws.cloudformation.model.UpdateStackResponse.wrap(buildAwsValue())
}
object UpdateStackResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.cloudformation.model.UpdateStackResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.cloudformation.model.UpdateStackResponse =
      zio.aws.cloudformation.model
        .UpdateStackResponse(stackId.map(value => value))
    def stackId: Option[StackId]
    def getStackId: ZIO[Any, AwsError, StackId] =
      AwsError.unwrapOptionField("stackId", stackId)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.cloudformation.model.UpdateStackResponse
  ) extends zio.aws.cloudformation.model.UpdateStackResponse.ReadOnly {
    override val stackId: Option[StackId] = scala
      .Option(impl.stackId())
      .map(value => zio.aws.cloudformation.model.primitives.StackId(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.cloudformation.model.UpdateStackResponse
  ): zio.aws.cloudformation.model.UpdateStackResponse.ReadOnly = new Wrapper(
    impl
  )
}
