package zio.aws.cloudformation.model
import zio.aws.cloudformation.model.primitives.{
  TypeName,
  TypeConfigurationArn,
  TypeConfigurationAlias,
  TypeArn
}
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters._
final case class TypeConfigurationIdentifier(
    typeArn: Option[TypeArn] = None,
    typeConfigurationAlias: Option[TypeConfigurationAlias] = None,
    typeConfigurationArn: Option[TypeConfigurationArn] = None,
    `type`: Option[zio.aws.cloudformation.model.ThirdPartyType] = None,
    typeName: Option[TypeName] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.cloudformation.model.TypeConfigurationIdentifier = {
    import TypeConfigurationIdentifier.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.cloudformation.model.TypeConfigurationIdentifier
      .builder()
      .optionallyWith(
        typeArn.map(value => TypeArn.unwrap(value): java.lang.String)
      )(_.typeArn)
      .optionallyWith(
        typeConfigurationAlias.map(value =>
          TypeConfigurationAlias.unwrap(value): java.lang.String
        )
      )(_.typeConfigurationAlias)
      .optionallyWith(
        typeConfigurationArn.map(value =>
          TypeConfigurationArn.unwrap(value): java.lang.String
        )
      )(_.typeConfigurationArn)
      .optionallyWith(`type`.map(value => value.unwrap))(_.`type`)
      .optionallyWith(
        typeName.map(value => TypeName.unwrap(value): java.lang.String)
      )(_.typeName)
      .build()
  }
  def asReadOnly
      : zio.aws.cloudformation.model.TypeConfigurationIdentifier.ReadOnly =
    zio.aws.cloudformation.model.TypeConfigurationIdentifier
      .wrap(buildAwsValue())
}
object TypeConfigurationIdentifier {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.cloudformation.model.TypeConfigurationIdentifier
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.cloudformation.model.TypeConfigurationIdentifier =
      zio.aws.cloudformation.model.TypeConfigurationIdentifier(
        typeArn.map(value => value),
        typeConfigurationAlias.map(value => value),
        typeConfigurationArn.map(value => value),
        `type`.map(value => value),
        typeName.map(value => value)
      )
    def typeArn: Option[TypeArn]
    def typeConfigurationAlias: Option[TypeConfigurationAlias]
    def typeConfigurationArn: Option[TypeConfigurationArn]
    def `type`: Option[zio.aws.cloudformation.model.ThirdPartyType]
    def typeName: Option[TypeName]
    def getTypeArn: ZIO[Any, AwsError, TypeArn] =
      AwsError.unwrapOptionField("typeArn", typeArn)
    def getTypeConfigurationAlias: ZIO[Any, AwsError, TypeConfigurationAlias] =
      AwsError.unwrapOptionField(
        "typeConfigurationAlias",
        typeConfigurationAlias
      )
    def getTypeConfigurationArn: ZIO[Any, AwsError, TypeConfigurationArn] =
      AwsError.unwrapOptionField("typeConfigurationArn", typeConfigurationArn)
    def getType
        : ZIO[Any, AwsError, zio.aws.cloudformation.model.ThirdPartyType] =
      AwsError.unwrapOptionField("type", `type`)
    def getTypeName: ZIO[Any, AwsError, TypeName] =
      AwsError.unwrapOptionField("typeName", typeName)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.cloudformation.model.TypeConfigurationIdentifier
  ) extends zio.aws.cloudformation.model.TypeConfigurationIdentifier.ReadOnly {
    override val typeArn: Option[TypeArn] = scala
      .Option(impl.typeArn())
      .map(value => zio.aws.cloudformation.model.primitives.TypeArn(value))
    override val typeConfigurationAlias: Option[TypeConfigurationAlias] = scala
      .Option(impl.typeConfigurationAlias())
      .map(value =>
        zio.aws.cloudformation.model.primitives.TypeConfigurationAlias(value)
      )
    override val typeConfigurationArn: Option[TypeConfigurationArn] = scala
      .Option(impl.typeConfigurationArn())
      .map(value =>
        zio.aws.cloudformation.model.primitives.TypeConfigurationArn(value)
      )
    override val `type`: Option[zio.aws.cloudformation.model.ThirdPartyType] =
      scala
        .Option(impl.`type`())
        .map(value => zio.aws.cloudformation.model.ThirdPartyType.wrap(value))
    override val typeName: Option[TypeName] = scala
      .Option(impl.typeName())
      .map(value => zio.aws.cloudformation.model.primitives.TypeName(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.cloudformation.model.TypeConfigurationIdentifier
  ): zio.aws.cloudformation.model.TypeConfigurationIdentifier.ReadOnly =
    new Wrapper(impl)
}
