package zio.aws.cloudformation.model
import zio.aws.cloudformation.model.primitives.{
  IsDefaultConfiguration,
  TypeArn,
  Timestamp,
  TypeConfiguration,
  TypeConfigurationArn,
  TypeName,
  TypeConfigurationAlias
}
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import java.time.Instant
import scala.jdk.CollectionConverters._
final case class TypeConfigurationDetails(
    arn: Option[TypeConfigurationArn] = None,
    alias: Option[TypeConfigurationAlias] = None,
    configuration: Option[TypeConfiguration] = None,
    lastUpdated: Option[Timestamp] = None,
    typeArn: Option[TypeArn] = None,
    typeName: Option[TypeName] = None,
    isDefaultConfiguration: Option[IsDefaultConfiguration] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.cloudformation.model.TypeConfigurationDetails = {
    import TypeConfigurationDetails.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.cloudformation.model.TypeConfigurationDetails
      .builder()
      .optionallyWith(
        arn.map(value => TypeConfigurationArn.unwrap(value): java.lang.String)
      )(_.arn)
      .optionallyWith(
        alias.map(value =>
          TypeConfigurationAlias.unwrap(value): java.lang.String
        )
      )(_.alias)
      .optionallyWith(
        configuration.map(value =>
          TypeConfiguration.unwrap(value): java.lang.String
        )
      )(_.configuration)
      .optionallyWith(
        lastUpdated.map(value => Timestamp.unwrap(value): Instant)
      )(_.lastUpdated)
      .optionallyWith(
        typeArn.map(value => TypeArn.unwrap(value): java.lang.String)
      )(_.typeArn)
      .optionallyWith(
        typeName.map(value => TypeName.unwrap(value): java.lang.String)
      )(_.typeName)
      .optionallyWith(
        isDefaultConfiguration.map(value =>
          IsDefaultConfiguration.unwrap(value): java.lang.Boolean
        )
      )(_.isDefaultConfiguration)
      .build()
  }
  def asReadOnly
      : zio.aws.cloudformation.model.TypeConfigurationDetails.ReadOnly =
    zio.aws.cloudformation.model.TypeConfigurationDetails.wrap(buildAwsValue())
}
object TypeConfigurationDetails {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.cloudformation.model.TypeConfigurationDetails
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.cloudformation.model.TypeConfigurationDetails =
      zio.aws.cloudformation.model.TypeConfigurationDetails(
        arn.map(value => value),
        alias.map(value => value),
        configuration.map(value => value),
        lastUpdated.map(value => value),
        typeArn.map(value => value),
        typeName.map(value => value),
        isDefaultConfiguration.map(value => value)
      )
    def arn: Option[TypeConfigurationArn]
    def alias: Option[TypeConfigurationAlias]
    def configuration: Option[TypeConfiguration]
    def lastUpdated: Option[Timestamp]
    def typeArn: Option[TypeArn]
    def typeName: Option[TypeName]
    def isDefaultConfiguration: Option[IsDefaultConfiguration]
    def getArn: ZIO[Any, AwsError, TypeConfigurationArn] =
      AwsError.unwrapOptionField("arn", arn)
    def getAlias: ZIO[Any, AwsError, TypeConfigurationAlias] =
      AwsError.unwrapOptionField("alias", alias)
    def getConfiguration: ZIO[Any, AwsError, TypeConfiguration] =
      AwsError.unwrapOptionField("configuration", configuration)
    def getLastUpdated: ZIO[Any, AwsError, Timestamp] =
      AwsError.unwrapOptionField("lastUpdated", lastUpdated)
    def getTypeArn: ZIO[Any, AwsError, TypeArn] =
      AwsError.unwrapOptionField("typeArn", typeArn)
    def getTypeName: ZIO[Any, AwsError, TypeName] =
      AwsError.unwrapOptionField("typeName", typeName)
    def getIsDefaultConfiguration: ZIO[Any, AwsError, IsDefaultConfiguration] =
      AwsError.unwrapOptionField(
        "isDefaultConfiguration",
        isDefaultConfiguration
      )
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.cloudformation.model.TypeConfigurationDetails
  ) extends zio.aws.cloudformation.model.TypeConfigurationDetails.ReadOnly {
    override val arn: Option[TypeConfigurationArn] = scala
      .Option(impl.arn())
      .map(value =>
        zio.aws.cloudformation.model.primitives.TypeConfigurationArn(value)
      )
    override val alias: Option[TypeConfigurationAlias] = scala
      .Option(impl.alias())
      .map(value =>
        zio.aws.cloudformation.model.primitives.TypeConfigurationAlias(value)
      )
    override val configuration: Option[TypeConfiguration] = scala
      .Option(impl.configuration())
      .map(value =>
        zio.aws.cloudformation.model.primitives.TypeConfiguration(value)
      )
    override val lastUpdated: Option[Timestamp] = scala
      .Option(impl.lastUpdated())
      .map(value => zio.aws.cloudformation.model.primitives.Timestamp(value))
    override val typeArn: Option[TypeArn] = scala
      .Option(impl.typeArn())
      .map(value => zio.aws.cloudformation.model.primitives.TypeArn(value))
    override val typeName: Option[TypeName] = scala
      .Option(impl.typeName())
      .map(value => zio.aws.cloudformation.model.primitives.TypeName(value))
    override val isDefaultConfiguration: Option[IsDefaultConfiguration] = scala
      .Option(impl.isDefaultConfiguration())
      .map(value =>
        zio.aws.cloudformation.model.primitives.IsDefaultConfiguration(value)
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.cloudformation.model.TypeConfigurationDetails
  ): zio.aws.cloudformation.model.TypeConfigurationDetails.ReadOnly =
    new Wrapper(impl)
}
