package zio.aws.cloudformation.model
import zio.aws.cloudformation.model.primitives.{
  StackSetNameOrId,
  StackNameOrId,
  TemplateURL,
  TemplateBody
}
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters._
final case class GetTemplateSummaryRequest(
    templateBody: Option[TemplateBody] = None,
    templateURL: Option[TemplateURL] = None,
    stackName: Option[StackNameOrId] = None,
    stackSetName: Option[StackSetNameOrId] = None,
    callAs: Option[zio.aws.cloudformation.model.CallAs] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.cloudformation.model.GetTemplateSummaryRequest = {
    import GetTemplateSummaryRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.cloudformation.model.GetTemplateSummaryRequest
      .builder()
      .optionallyWith(
        templateBody.map(value => TemplateBody.unwrap(value): java.lang.String)
      )(_.templateBody)
      .optionallyWith(
        templateURL.map(value => TemplateURL.unwrap(value): java.lang.String)
      )(_.templateURL)
      .optionallyWith(
        stackName.map(value => StackNameOrId.unwrap(value): java.lang.String)
      )(_.stackName)
      .optionallyWith(
        stackSetName.map(value =>
          StackSetNameOrId.unwrap(value): java.lang.String
        )
      )(_.stackSetName)
      .optionallyWith(callAs.map(value => value.unwrap))(_.callAs)
      .build()
  }
  def asReadOnly
      : zio.aws.cloudformation.model.GetTemplateSummaryRequest.ReadOnly =
    zio.aws.cloudformation.model.GetTemplateSummaryRequest.wrap(buildAwsValue())
}
object GetTemplateSummaryRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.cloudformation.model.GetTemplateSummaryRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.cloudformation.model.GetTemplateSummaryRequest =
      zio.aws.cloudformation.model.GetTemplateSummaryRequest(
        templateBody.map(value => value),
        templateURL.map(value => value),
        stackName.map(value => value),
        stackSetName.map(value => value),
        callAs.map(value => value)
      )
    def templateBody: Option[TemplateBody]
    def templateURL: Option[TemplateURL]
    def stackName: Option[StackNameOrId]
    def stackSetName: Option[StackSetNameOrId]
    def callAs: Option[zio.aws.cloudformation.model.CallAs]
    def getTemplateBody: ZIO[Any, AwsError, TemplateBody] =
      AwsError.unwrapOptionField("templateBody", templateBody)
    def getTemplateURL: ZIO[Any, AwsError, TemplateURL] =
      AwsError.unwrapOptionField("templateURL", templateURL)
    def getStackName: ZIO[Any, AwsError, StackNameOrId] =
      AwsError.unwrapOptionField("stackName", stackName)
    def getStackSetName: ZIO[Any, AwsError, StackSetNameOrId] =
      AwsError.unwrapOptionField("stackSetName", stackSetName)
    def getCallAs: ZIO[Any, AwsError, zio.aws.cloudformation.model.CallAs] =
      AwsError.unwrapOptionField("callAs", callAs)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.cloudformation.model.GetTemplateSummaryRequest
  ) extends zio.aws.cloudformation.model.GetTemplateSummaryRequest.ReadOnly {
    override val templateBody: Option[TemplateBody] = scala
      .Option(impl.templateBody())
      .map(value => zio.aws.cloudformation.model.primitives.TemplateBody(value))
    override val templateURL: Option[TemplateURL] = scala
      .Option(impl.templateURL())
      .map(value => zio.aws.cloudformation.model.primitives.TemplateURL(value))
    override val stackName: Option[StackNameOrId] = scala
      .Option(impl.stackName())
      .map(value =>
        zio.aws.cloudformation.model.primitives.StackNameOrId(value)
      )
    override val stackSetName: Option[StackSetNameOrId] = scala
      .Option(impl.stackSetName())
      .map(value =>
        zio.aws.cloudformation.model.primitives.StackSetNameOrId(value)
      )
    override val callAs: Option[zio.aws.cloudformation.model.CallAs] = scala
      .Option(impl.callAs())
      .map(value => zio.aws.cloudformation.model.CallAs.wrap(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.cloudformation.model.GetTemplateSummaryRequest
  ): zio.aws.cloudformation.model.GetTemplateSummaryRequest.ReadOnly =
    new Wrapper(impl)
}
