package zio.aws.cloudformation.model
import zio.aws.cloudformation.model.primitives.{
  TypeVersionId,
  PublisherId,
  PublicVersionNumber,
  TypeArn,
  TypeName
}
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters._
final case class DescribeTypeRequest(
    `type`: Option[zio.aws.cloudformation.model.RegistryType] = None,
    typeName: Option[TypeName] = None,
    arn: Option[TypeArn] = None,
    versionId: Option[TypeVersionId] = None,
    publisherId: Option[PublisherId] = None,
    publicVersionNumber: Option[PublicVersionNumber] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.cloudformation.model.DescribeTypeRequest = {
    import DescribeTypeRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.cloudformation.model.DescribeTypeRequest
      .builder()
      .optionallyWith(`type`.map(value => value.unwrap))(_.`type`)
      .optionallyWith(
        typeName.map(value => TypeName.unwrap(value): java.lang.String)
      )(_.typeName)
      .optionallyWith(
        arn.map(value => TypeArn.unwrap(value): java.lang.String)
      )(_.arn)
      .optionallyWith(
        versionId.map(value => TypeVersionId.unwrap(value): java.lang.String)
      )(_.versionId)
      .optionallyWith(
        publisherId.map(value => PublisherId.unwrap(value): java.lang.String)
      )(_.publisherId)
      .optionallyWith(
        publicVersionNumber.map(value =>
          PublicVersionNumber.unwrap(value): java.lang.String
        )
      )(_.publicVersionNumber)
      .build()
  }
  def asReadOnly: zio.aws.cloudformation.model.DescribeTypeRequest.ReadOnly =
    zio.aws.cloudformation.model.DescribeTypeRequest.wrap(buildAwsValue())
}
object DescribeTypeRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.cloudformation.model.DescribeTypeRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.cloudformation.model.DescribeTypeRequest =
      zio.aws.cloudformation.model.DescribeTypeRequest(
        `type`.map(value => value),
        typeName.map(value => value),
        arn.map(value => value),
        versionId.map(value => value),
        publisherId.map(value => value),
        publicVersionNumber.map(value => value)
      )
    def `type`: Option[zio.aws.cloudformation.model.RegistryType]
    def typeName: Option[TypeName]
    def arn: Option[TypeArn]
    def versionId: Option[TypeVersionId]
    def publisherId: Option[PublisherId]
    def publicVersionNumber: Option[PublicVersionNumber]
    def getType: ZIO[Any, AwsError, zio.aws.cloudformation.model.RegistryType] =
      AwsError.unwrapOptionField("type", `type`)
    def getTypeName: ZIO[Any, AwsError, TypeName] =
      AwsError.unwrapOptionField("typeName", typeName)
    def getArn: ZIO[Any, AwsError, TypeArn] =
      AwsError.unwrapOptionField("arn", arn)
    def getVersionId: ZIO[Any, AwsError, TypeVersionId] =
      AwsError.unwrapOptionField("versionId", versionId)
    def getPublisherId: ZIO[Any, AwsError, PublisherId] =
      AwsError.unwrapOptionField("publisherId", publisherId)
    def getPublicVersionNumber: ZIO[Any, AwsError, PublicVersionNumber] =
      AwsError.unwrapOptionField("publicVersionNumber", publicVersionNumber)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.cloudformation.model.DescribeTypeRequest
  ) extends zio.aws.cloudformation.model.DescribeTypeRequest.ReadOnly {
    override val `type`: Option[zio.aws.cloudformation.model.RegistryType] =
      scala
        .Option(impl.`type`())
        .map(value => zio.aws.cloudformation.model.RegistryType.wrap(value))
    override val typeName: Option[TypeName] = scala
      .Option(impl.typeName())
      .map(value => zio.aws.cloudformation.model.primitives.TypeName(value))
    override val arn: Option[TypeArn] = scala
      .Option(impl.arn())
      .map(value => zio.aws.cloudformation.model.primitives.TypeArn(value))
    override val versionId: Option[TypeVersionId] = scala
      .Option(impl.versionId())
      .map(value =>
        zio.aws.cloudformation.model.primitives.TypeVersionId(value)
      )
    override val publisherId: Option[PublisherId] = scala
      .Option(impl.publisherId())
      .map(value => zio.aws.cloudformation.model.primitives.PublisherId(value))
    override val publicVersionNumber: Option[PublicVersionNumber] = scala
      .Option(impl.publicVersionNumber())
      .map(value =>
        zio.aws.cloudformation.model.primitives.PublicVersionNumber(value)
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.cloudformation.model.DescribeTypeRequest
  ): zio.aws.cloudformation.model.DescribeTypeRequest.ReadOnly = new Wrapper(
    impl
  )
}
