package zio.aws.cloudformation.model
import scala.jdk.CollectionConverters._
sealed trait DeprecatedStatus {
  def unwrap
      : software.amazon.awssdk.services.cloudformation.model.DeprecatedStatus
}
object DeprecatedStatus {
  def wrap(
      value: software.amazon.awssdk.services.cloudformation.model.DeprecatedStatus
  ): zio.aws.cloudformation.model.DeprecatedStatus = value match {
    case software.amazon.awssdk.services.cloudformation.model.DeprecatedStatus.UNKNOWN_TO_SDK_VERSION =>
      val r = unknownToSdkVersion
      r
    case software.amazon.awssdk.services.cloudformation.model.DeprecatedStatus.LIVE =>
      val r = LIVE
      r
    case software.amazon.awssdk.services.cloudformation.model.DeprecatedStatus.DEPRECATED =>
      val r = DEPRECATED
      r
  }
  case object unknownToSdkVersion
      extends zio.aws.cloudformation.model.DeprecatedStatus {
    override def unwrap
        : software.amazon.awssdk.services.cloudformation.model.DeprecatedStatus =
      software.amazon.awssdk.services.cloudformation.model.DeprecatedStatus.UNKNOWN_TO_SDK_VERSION
  }
  case object LIVE extends zio.aws.cloudformation.model.DeprecatedStatus {
    override def unwrap
        : software.amazon.awssdk.services.cloudformation.model.DeprecatedStatus =
      software.amazon.awssdk.services.cloudformation.model.DeprecatedStatus.LIVE
  }
  case object DEPRECATED extends zio.aws.cloudformation.model.DeprecatedStatus {
    override def unwrap
        : software.amazon.awssdk.services.cloudformation.model.DeprecatedStatus =
      software.amazon.awssdk.services.cloudformation.model.DeprecatedStatus.DEPRECATED
  }
}
