package zio.aws.cloudformation.model
import zio.aws.cloudformation.model.primitives.{
  Account,
  RetainStacks,
  StackSetName,
  ClientRequestToken,
  Region
}
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters._
final case class DeleteStackInstancesRequest(
    stackSetName: StackSetName,
    accounts: Option[Iterable[Account]] = None,
    deploymentTargets: Option[zio.aws.cloudformation.model.DeploymentTargets] =
      None,
    regions: Iterable[Region],
    operationPreferences: Option[
      zio.aws.cloudformation.model.StackSetOperationPreferences
    ] = None,
    retainStacks: RetainStacks,
    operationId: Option[ClientRequestToken] = None,
    callAs: Option[zio.aws.cloudformation.model.CallAs] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.cloudformation.model.DeleteStackInstancesRequest = {
    import DeleteStackInstancesRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.cloudformation.model.DeleteStackInstancesRequest
      .builder()
      .stackSetName(StackSetName.unwrap(stackSetName): java.lang.String)
      .optionallyWith(
        accounts.map(value =>
          value.map { item =>
            Account.unwrap(item): java.lang.String
          }.asJavaCollection
        )
      )(_.accounts)
      .optionallyWith(deploymentTargets.map(value => value.buildAwsValue()))(
        _.deploymentTargets
      )
      .regions(regions.map { item =>
        Region.unwrap(item): java.lang.String
      }.asJavaCollection)
      .optionallyWith(operationPreferences.map(value => value.buildAwsValue()))(
        _.operationPreferences
      )
      .retainStacks(RetainStacks.unwrap(retainStacks): java.lang.Boolean)
      .optionallyWith(
        operationId.map(value =>
          ClientRequestToken.unwrap(value): java.lang.String
        )
      )(_.operationId)
      .optionallyWith(callAs.map(value => value.unwrap))(_.callAs)
      .build()
  }
  def asReadOnly
      : zio.aws.cloudformation.model.DeleteStackInstancesRequest.ReadOnly =
    zio.aws.cloudformation.model.DeleteStackInstancesRequest
      .wrap(buildAwsValue())
}
object DeleteStackInstancesRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.cloudformation.model.DeleteStackInstancesRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.cloudformation.model.DeleteStackInstancesRequest =
      zio.aws.cloudformation.model.DeleteStackInstancesRequest(
        stackSetName,
        accounts.map(value => value),
        deploymentTargets.map(value => value.asEditable),
        regions,
        operationPreferences.map(value => value.asEditable),
        retainStacks,
        operationId.map(value => value),
        callAs.map(value => value)
      )
    def stackSetName: StackSetName
    def accounts: Option[List[Account]]
    def deploymentTargets
        : Option[zio.aws.cloudformation.model.DeploymentTargets.ReadOnly]
    def regions: List[Region]
    def operationPreferences: Option[
      zio.aws.cloudformation.model.StackSetOperationPreferences.ReadOnly
    ]
    def retainStacks: RetainStacks
    def operationId: Option[ClientRequestToken]
    def callAs: Option[zio.aws.cloudformation.model.CallAs]
    def getStackSetName: ZIO[Any, Nothing, StackSetName] =
      ZIO.succeed(stackSetName)
    def getAccounts: ZIO[Any, AwsError, List[Account]] =
      AwsError.unwrapOptionField("accounts", accounts)
    def getDeploymentTargets: ZIO[
      Any,
      AwsError,
      zio.aws.cloudformation.model.DeploymentTargets.ReadOnly
    ] = AwsError.unwrapOptionField("deploymentTargets", deploymentTargets)
    def getRegions: ZIO[Any, Nothing, List[Region]] = ZIO.succeed(regions)
    def getOperationPreferences: ZIO[
      Any,
      AwsError,
      zio.aws.cloudformation.model.StackSetOperationPreferences.ReadOnly
    ] = AwsError.unwrapOptionField("operationPreferences", operationPreferences)
    def getRetainStacks: ZIO[Any, Nothing, RetainStacks] =
      ZIO.succeed(retainStacks)
    def getOperationId: ZIO[Any, AwsError, ClientRequestToken] =
      AwsError.unwrapOptionField("operationId", operationId)
    def getCallAs: ZIO[Any, AwsError, zio.aws.cloudformation.model.CallAs] =
      AwsError.unwrapOptionField("callAs", callAs)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.cloudformation.model.DeleteStackInstancesRequest
  ) extends zio.aws.cloudformation.model.DeleteStackInstancesRequest.ReadOnly {
    override val stackSetName: StackSetName =
      zio.aws.cloudformation.model.primitives.StackSetName(impl.stackSetName())
    override val accounts: Option[List[Account]] = scala
      .Option(impl.accounts())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.cloudformation.model.primitives.Account(item)
        }.toList
      )
    override val deploymentTargets
        : Option[zio.aws.cloudformation.model.DeploymentTargets.ReadOnly] =
      scala
        .Option(impl.deploymentTargets())
        .map(value =>
          zio.aws.cloudformation.model.DeploymentTargets.wrap(value)
        )
    override val regions: List[Region] = impl
      .regions()
      .asScala
      .map { item =>
        zio.aws.cloudformation.model.primitives.Region(item)
      }
      .toList
    override val operationPreferences: Option[
      zio.aws.cloudformation.model.StackSetOperationPreferences.ReadOnly
    ] = scala
      .Option(impl.operationPreferences())
      .map(value =>
        zio.aws.cloudformation.model.StackSetOperationPreferences.wrap(value)
      )
    override val retainStacks: RetainStacks =
      zio.aws.cloudformation.model.primitives.RetainStacks(impl.retainStacks())
    override val operationId: Option[ClientRequestToken] = scala
      .Option(impl.operationId())
      .map(value =>
        zio.aws.cloudformation.model.primitives.ClientRequestToken(value)
      )
    override val callAs: Option[zio.aws.cloudformation.model.CallAs] = scala
      .Option(impl.callAs())
      .map(value => zio.aws.cloudformation.model.CallAs.wrap(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.cloudformation.model.DeleteStackInstancesRequest
  ): zio.aws.cloudformation.model.DeleteStackInstancesRequest.ReadOnly =
    new Wrapper(impl)
}
