package zio.aws.cloudformation.model
import zio.aws.cloudformation.model.primitives.{PrivateTypeArn, TypeName}
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters._
final case class DeactivateTypeRequest(
    typeName: Option[TypeName] = None,
    `type`: Option[zio.aws.cloudformation.model.ThirdPartyType] = None,
    arn: Option[PrivateTypeArn] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.cloudformation.model.DeactivateTypeRequest = {
    import DeactivateTypeRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.cloudformation.model.DeactivateTypeRequest
      .builder()
      .optionallyWith(
        typeName.map(value => TypeName.unwrap(value): java.lang.String)
      )(_.typeName)
      .optionallyWith(`type`.map(value => value.unwrap))(_.`type`)
      .optionallyWith(
        arn.map(value => PrivateTypeArn.unwrap(value): java.lang.String)
      )(_.arn)
      .build()
  }
  def asReadOnly: zio.aws.cloudformation.model.DeactivateTypeRequest.ReadOnly =
    zio.aws.cloudformation.model.DeactivateTypeRequest.wrap(buildAwsValue())
}
object DeactivateTypeRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.cloudformation.model.DeactivateTypeRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.cloudformation.model.DeactivateTypeRequest =
      zio.aws.cloudformation.model.DeactivateTypeRequest(
        typeName.map(value => value),
        `type`.map(value => value),
        arn.map(value => value)
      )
    def typeName: Option[TypeName]
    def `type`: Option[zio.aws.cloudformation.model.ThirdPartyType]
    def arn: Option[PrivateTypeArn]
    def getTypeName: ZIO[Any, AwsError, TypeName] =
      AwsError.unwrapOptionField("typeName", typeName)
    def getType
        : ZIO[Any, AwsError, zio.aws.cloudformation.model.ThirdPartyType] =
      AwsError.unwrapOptionField("type", `type`)
    def getArn: ZIO[Any, AwsError, PrivateTypeArn] =
      AwsError.unwrapOptionField("arn", arn)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.cloudformation.model.DeactivateTypeRequest
  ) extends zio.aws.cloudformation.model.DeactivateTypeRequest.ReadOnly {
    override val typeName: Option[TypeName] = scala
      .Option(impl.typeName())
      .map(value => zio.aws.cloudformation.model.primitives.TypeName(value))
    override val `type`: Option[zio.aws.cloudformation.model.ThirdPartyType] =
      scala
        .Option(impl.`type`())
        .map(value => zio.aws.cloudformation.model.ThirdPartyType.wrap(value))
    override val arn: Option[PrivateTypeArn] = scala
      .Option(impl.arn())
      .map(value =>
        zio.aws.cloudformation.model.primitives.PrivateTypeArn(value)
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.cloudformation.model.DeactivateTypeRequest
  ): zio.aws.cloudformation.model.DeactivateTypeRequest.ReadOnly = new Wrapper(
    impl
  )
}
