package zio.aws.cloudformation.model
import zio.aws.cloudformation.model.primitives.StackId
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters._
final case class CreateStackResponse(stackId: Option[StackId] = None) {
  def buildAwsValue()
      : software.amazon.awssdk.services.cloudformation.model.CreateStackResponse = {
    import CreateStackResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.cloudformation.model.CreateStackResponse
      .builder()
      .optionallyWith(
        stackId.map(value => StackId.unwrap(value): java.lang.String)
      )(_.stackId)
      .build()
  }
  def asReadOnly: zio.aws.cloudformation.model.CreateStackResponse.ReadOnly =
    zio.aws.cloudformation.model.CreateStackResponse.wrap(buildAwsValue())
}
object CreateStackResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.cloudformation.model.CreateStackResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.cloudformation.model.CreateStackResponse =
      zio.aws.cloudformation.model
        .CreateStackResponse(stackId.map(value => value))
    def stackId: Option[StackId]
    def getStackId: ZIO[Any, AwsError, StackId] =
      AwsError.unwrapOptionField("stackId", stackId)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.cloudformation.model.CreateStackResponse
  ) extends zio.aws.cloudformation.model.CreateStackResponse.ReadOnly {
    override val stackId: Option[StackId] = scala
      .Option(impl.stackId())
      .map(value => zio.aws.cloudformation.model.primitives.StackId(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.cloudformation.model.CreateStackResponse
  ): zio.aws.cloudformation.model.CreateStackResponse.ReadOnly = new Wrapper(
    impl
  )
}
