package zio.aws.cloudformation.model
import java.lang.Integer
import zio.aws.cloudformation.model.primitives.{LimitValue, LimitName}
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters._
final case class AccountLimit(
    name: Option[LimitName] = None,
    value: Option[LimitValue] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.cloudformation.model.AccountLimit = {
    import AccountLimit.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.cloudformation.model.AccountLimit
      .builder()
      .optionallyWith(
        name.map(value => LimitName.unwrap(value): java.lang.String)
      )(_.name)
      .optionallyWith(value.map(value => LimitValue.unwrap(value): Integer))(
        _.value
      )
      .build()
  }
  def asReadOnly: zio.aws.cloudformation.model.AccountLimit.ReadOnly =
    zio.aws.cloudformation.model.AccountLimit.wrap(buildAwsValue())
}
object AccountLimit {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.cloudformation.model.AccountLimit
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.cloudformation.model.AccountLimit =
      zio.aws.cloudformation.model
        .AccountLimit(name.map(value => value), value.map(value => value))
    def name: Option[LimitName]
    def value: Option[LimitValue]
    def getName: ZIO[Any, AwsError, LimitName] =
      AwsError.unwrapOptionField("name", name)
    def getValue: ZIO[Any, AwsError, LimitValue] =
      AwsError.unwrapOptionField("value", value)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.cloudformation.model.AccountLimit
  ) extends zio.aws.cloudformation.model.AccountLimit.ReadOnly {
    override val name: Option[LimitName] = scala
      .Option(impl.name())
      .map(value => zio.aws.cloudformation.model.primitives.LimitName(value))
    override val value: Option[LimitValue] = scala
      .Option(impl.value())
      .map(value => zio.aws.cloudformation.model.primitives.LimitValue(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.cloudformation.model.AccountLimit
  ): zio.aws.cloudformation.model.AccountLimit.ReadOnly = new Wrapper(impl)
}
