package zio.aws.cloudformation.model
import zio.aws.cloudformation.model.primitives.{
  LogicalResourceId,
  Timestamp,
  ResourceStatusReason,
  PhysicalResourceId,
  ResourceType
}
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import java.time.Instant
import scala.jdk.CollectionConverters._
final case class StackResourceSummary(
    logicalResourceId: LogicalResourceId,
    physicalResourceId: Option[PhysicalResourceId] = None,
    resourceType: ResourceType,
    lastUpdatedTimestamp: Timestamp,
    resourceStatus: zio.aws.cloudformation.model.ResourceStatus,
    resourceStatusReason: Option[ResourceStatusReason] = None,
    driftInformation: Option[
      zio.aws.cloudformation.model.StackResourceDriftInformationSummary
    ] = None,
    moduleInfo: Option[zio.aws.cloudformation.model.ModuleInfo] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.cloudformation.model.StackResourceSummary = {
    import StackResourceSummary.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.cloudformation.model.StackResourceSummary
      .builder()
      .logicalResourceId(
        LogicalResourceId.unwrap(logicalResourceId): java.lang.String
      )
      .optionallyWith(
        physicalResourceId.map(value =>
          PhysicalResourceId.unwrap(value): java.lang.String
        )
      )(_.physicalResourceId)
      .resourceType(ResourceType.unwrap(resourceType): java.lang.String)
      .lastUpdatedTimestamp(Timestamp.unwrap(lastUpdatedTimestamp): Instant)
      .resourceStatus(resourceStatus.unwrap)
      .optionallyWith(
        resourceStatusReason.map(value =>
          ResourceStatusReason.unwrap(value): java.lang.String
        )
      )(_.resourceStatusReason)
      .optionallyWith(driftInformation.map(value => value.buildAwsValue()))(
        _.driftInformation
      )
      .optionallyWith(moduleInfo.map(value => value.buildAwsValue()))(
        _.moduleInfo
      )
      .build()
  }
  def asReadOnly: zio.aws.cloudformation.model.StackResourceSummary.ReadOnly =
    zio.aws.cloudformation.model.StackResourceSummary.wrap(buildAwsValue())
}
object StackResourceSummary {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.cloudformation.model.StackResourceSummary
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.cloudformation.model.StackResourceSummary =
      zio.aws.cloudformation.model.StackResourceSummary(
        logicalResourceId,
        physicalResourceId.map(value => value),
        resourceType,
        lastUpdatedTimestamp,
        resourceStatus,
        resourceStatusReason.map(value => value),
        driftInformation.map(value => value.asEditable),
        moduleInfo.map(value => value.asEditable)
      )
    def logicalResourceId: LogicalResourceId
    def physicalResourceId: Option[PhysicalResourceId]
    def resourceType: ResourceType
    def lastUpdatedTimestamp: Timestamp
    def resourceStatus: zio.aws.cloudformation.model.ResourceStatus
    def resourceStatusReason: Option[ResourceStatusReason]
    def driftInformation: Option[
      zio.aws.cloudformation.model.StackResourceDriftInformationSummary.ReadOnly
    ]
    def moduleInfo: Option[zio.aws.cloudformation.model.ModuleInfo.ReadOnly]
    def getLogicalResourceId: ZIO[Any, Nothing, LogicalResourceId] =
      ZIO.succeed(logicalResourceId)
    def getPhysicalResourceId: ZIO[Any, AwsError, PhysicalResourceId] =
      AwsError.unwrapOptionField("physicalResourceId", physicalResourceId)
    def getResourceType: ZIO[Any, Nothing, ResourceType] =
      ZIO.succeed(resourceType)
    def getLastUpdatedTimestamp: ZIO[Any, Nothing, Timestamp] =
      ZIO.succeed(lastUpdatedTimestamp)
    def getResourceStatus
        : ZIO[Any, Nothing, zio.aws.cloudformation.model.ResourceStatus] =
      ZIO.succeed(resourceStatus)
    def getResourceStatusReason: ZIO[Any, AwsError, ResourceStatusReason] =
      AwsError.unwrapOptionField("resourceStatusReason", resourceStatusReason)
    def getDriftInformation: ZIO[
      Any,
      AwsError,
      zio.aws.cloudformation.model.StackResourceDriftInformationSummary.ReadOnly
    ] = AwsError.unwrapOptionField("driftInformation", driftInformation)
    def getModuleInfo
        : ZIO[Any, AwsError, zio.aws.cloudformation.model.ModuleInfo.ReadOnly] =
      AwsError.unwrapOptionField("moduleInfo", moduleInfo)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.cloudformation.model.StackResourceSummary
  ) extends zio.aws.cloudformation.model.StackResourceSummary.ReadOnly {
    override val logicalResourceId: LogicalResourceId =
      zio.aws.cloudformation.model.primitives
        .LogicalResourceId(impl.logicalResourceId())
    override val physicalResourceId: Option[PhysicalResourceId] = scala
      .Option(impl.physicalResourceId())
      .map(value =>
        zio.aws.cloudformation.model.primitives.PhysicalResourceId(value)
      )
    override val resourceType: ResourceType =
      zio.aws.cloudformation.model.primitives.ResourceType(impl.resourceType())
    override val lastUpdatedTimestamp: Timestamp =
      zio.aws.cloudformation.model.primitives
        .Timestamp(impl.lastUpdatedTimestamp())
    override val resourceStatus: zio.aws.cloudformation.model.ResourceStatus =
      zio.aws.cloudformation.model.ResourceStatus.wrap(impl.resourceStatus())
    override val resourceStatusReason: Option[ResourceStatusReason] = scala
      .Option(impl.resourceStatusReason())
      .map(value =>
        zio.aws.cloudformation.model.primitives.ResourceStatusReason(value)
      )
    override val driftInformation: Option[
      zio.aws.cloudformation.model.StackResourceDriftInformationSummary.ReadOnly
    ] = scala
      .Option(impl.driftInformation())
      .map(value =>
        zio.aws.cloudformation.model.StackResourceDriftInformationSummary
          .wrap(value)
      )
    override val moduleInfo
        : Option[zio.aws.cloudformation.model.ModuleInfo.ReadOnly] = scala
      .Option(impl.moduleInfo())
      .map(value => zio.aws.cloudformation.model.ModuleInfo.wrap(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.cloudformation.model.StackResourceSummary
  ): zio.aws.cloudformation.model.StackResourceSummary.ReadOnly = new Wrapper(
    impl
  )
}
