package zio.aws.cloudformation.model
import java.lang.Integer
import zio.aws.cloudformation.model.primitives.{
  SupportedMajorVersion,
  PublisherId,
  TypeName
}
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters._
final case class RequiredActivatedType(
    typeNameAlias: Option[TypeName] = None,
    originalTypeName: Option[TypeName] = None,
    publisherId: Option[PublisherId] = None,
    supportedMajorVersions: Option[Iterable[SupportedMajorVersion]] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.cloudformation.model.RequiredActivatedType = {
    import RequiredActivatedType.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.cloudformation.model.RequiredActivatedType
      .builder()
      .optionallyWith(
        typeNameAlias.map(value => TypeName.unwrap(value): java.lang.String)
      )(_.typeNameAlias)
      .optionallyWith(
        originalTypeName.map(value => TypeName.unwrap(value): java.lang.String)
      )(_.originalTypeName)
      .optionallyWith(
        publisherId.map(value => PublisherId.unwrap(value): java.lang.String)
      )(_.publisherId)
      .optionallyWith(
        supportedMajorVersions.map(value =>
          value.map { item =>
            SupportedMajorVersion.unwrap(item): Integer
          }.asJavaCollection
        )
      )(_.supportedMajorVersions)
      .build()
  }
  def asReadOnly: zio.aws.cloudformation.model.RequiredActivatedType.ReadOnly =
    zio.aws.cloudformation.model.RequiredActivatedType.wrap(buildAwsValue())
}
object RequiredActivatedType {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.cloudformation.model.RequiredActivatedType
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.cloudformation.model.RequiredActivatedType =
      zio.aws.cloudformation.model.RequiredActivatedType(
        typeNameAlias.map(value => value),
        originalTypeName.map(value => value),
        publisherId.map(value => value),
        supportedMajorVersions.map(value => value)
      )
    def typeNameAlias: Option[TypeName]
    def originalTypeName: Option[TypeName]
    def publisherId: Option[PublisherId]
    def supportedMajorVersions: Option[List[SupportedMajorVersion]]
    def getTypeNameAlias: ZIO[Any, AwsError, TypeName] =
      AwsError.unwrapOptionField("typeNameAlias", typeNameAlias)
    def getOriginalTypeName: ZIO[Any, AwsError, TypeName] =
      AwsError.unwrapOptionField("originalTypeName", originalTypeName)
    def getPublisherId: ZIO[Any, AwsError, PublisherId] =
      AwsError.unwrapOptionField("publisherId", publisherId)
    def getSupportedMajorVersions
        : ZIO[Any, AwsError, List[SupportedMajorVersion]] = AwsError
      .unwrapOptionField("supportedMajorVersions", supportedMajorVersions)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.cloudformation.model.RequiredActivatedType
  ) extends zio.aws.cloudformation.model.RequiredActivatedType.ReadOnly {
    override val typeNameAlias: Option[TypeName] = scala
      .Option(impl.typeNameAlias())
      .map(value => zio.aws.cloudformation.model.primitives.TypeName(value))
    override val originalTypeName: Option[TypeName] = scala
      .Option(impl.originalTypeName())
      .map(value => zio.aws.cloudformation.model.primitives.TypeName(value))
    override val publisherId: Option[PublisherId] = scala
      .Option(impl.publisherId())
      .map(value => zio.aws.cloudformation.model.primitives.PublisherId(value))
    override val supportedMajorVersions: Option[List[SupportedMajorVersion]] =
      scala
        .Option(impl.supportedMajorVersions())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.cloudformation.model.primitives.SupportedMajorVersion(item)
          }.toList
        )
  }
  def wrap(
      impl: software.amazon.awssdk.services.cloudformation.model.RequiredActivatedType
  ): zio.aws.cloudformation.model.RequiredActivatedType.ReadOnly = new Wrapper(
    impl
  )
}
