package zio.aws.cloudformation.model
import zio.aws.cloudformation.model.primitives.{
  PublicVersionNumber,
  TypeName,
  PrivateTypeArn
}
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters._
final case class PublishTypeRequest(
    `type`: Option[zio.aws.cloudformation.model.ThirdPartyType] = None,
    arn: Option[PrivateTypeArn] = None,
    typeName: Option[TypeName] = None,
    publicVersionNumber: Option[PublicVersionNumber] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.cloudformation.model.PublishTypeRequest = {
    import PublishTypeRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.cloudformation.model.PublishTypeRequest
      .builder()
      .optionallyWith(`type`.map(value => value.unwrap))(_.`type`)
      .optionallyWith(
        arn.map(value => PrivateTypeArn.unwrap(value): java.lang.String)
      )(_.arn)
      .optionallyWith(
        typeName.map(value => TypeName.unwrap(value): java.lang.String)
      )(_.typeName)
      .optionallyWith(
        publicVersionNumber.map(value =>
          PublicVersionNumber.unwrap(value): java.lang.String
        )
      )(_.publicVersionNumber)
      .build()
  }
  def asReadOnly: zio.aws.cloudformation.model.PublishTypeRequest.ReadOnly =
    zio.aws.cloudformation.model.PublishTypeRequest.wrap(buildAwsValue())
}
object PublishTypeRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.cloudformation.model.PublishTypeRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.cloudformation.model.PublishTypeRequest =
      zio.aws.cloudformation.model.PublishTypeRequest(
        `type`.map(value => value),
        arn.map(value => value),
        typeName.map(value => value),
        publicVersionNumber.map(value => value)
      )
    def `type`: Option[zio.aws.cloudformation.model.ThirdPartyType]
    def arn: Option[PrivateTypeArn]
    def typeName: Option[TypeName]
    def publicVersionNumber: Option[PublicVersionNumber]
    def getType
        : ZIO[Any, AwsError, zio.aws.cloudformation.model.ThirdPartyType] =
      AwsError.unwrapOptionField("type", `type`)
    def getArn: ZIO[Any, AwsError, PrivateTypeArn] =
      AwsError.unwrapOptionField("arn", arn)
    def getTypeName: ZIO[Any, AwsError, TypeName] =
      AwsError.unwrapOptionField("typeName", typeName)
    def getPublicVersionNumber: ZIO[Any, AwsError, PublicVersionNumber] =
      AwsError.unwrapOptionField("publicVersionNumber", publicVersionNumber)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.cloudformation.model.PublishTypeRequest
  ) extends zio.aws.cloudformation.model.PublishTypeRequest.ReadOnly {
    override val `type`: Option[zio.aws.cloudformation.model.ThirdPartyType] =
      scala
        .Option(impl.`type`())
        .map(value => zio.aws.cloudformation.model.ThirdPartyType.wrap(value))
    override val arn: Option[PrivateTypeArn] = scala
      .Option(impl.arn())
      .map(value =>
        zio.aws.cloudformation.model.primitives.PrivateTypeArn(value)
      )
    override val typeName: Option[TypeName] = scala
      .Option(impl.typeName())
      .map(value => zio.aws.cloudformation.model.primitives.TypeName(value))
    override val publicVersionNumber: Option[PublicVersionNumber] = scala
      .Option(impl.publicVersionNumber())
      .map(value =>
        zio.aws.cloudformation.model.primitives.PublicVersionNumber(value)
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.cloudformation.model.PublishTypeRequest
  ): zio.aws.cloudformation.model.PublishTypeRequest.ReadOnly = new Wrapper(
    impl
  )
}
