package zio.aws.cloudformation.model
import zio.aws.cloudformation.model.primitives.NextToken
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters._
final case class ListTypesResponse(
    typeSummaries: Option[Iterable[zio.aws.cloudformation.model.TypeSummary]] =
      None,
    nextToken: Option[NextToken] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.cloudformation.model.ListTypesResponse = {
    import ListTypesResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.cloudformation.model.ListTypesResponse
      .builder()
      .optionallyWith(
        typeSummaries.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.typeSummaries)
      .optionallyWith(
        nextToken.map(value => NextToken.unwrap(value): java.lang.String)
      )(_.nextToken)
      .build()
  }
  def asReadOnly: zio.aws.cloudformation.model.ListTypesResponse.ReadOnly =
    zio.aws.cloudformation.model.ListTypesResponse.wrap(buildAwsValue())
}
object ListTypesResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.cloudformation.model.ListTypesResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.cloudformation.model.ListTypesResponse =
      zio.aws.cloudformation.model.ListTypesResponse(
        typeSummaries.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        nextToken.map(value => value)
      )
    def typeSummaries
        : Option[List[zio.aws.cloudformation.model.TypeSummary.ReadOnly]]
    def nextToken: Option[NextToken]
    def getTypeSummaries: ZIO[Any, AwsError, List[
      zio.aws.cloudformation.model.TypeSummary.ReadOnly
    ]] = AwsError.unwrapOptionField("typeSummaries", typeSummaries)
    def getNextToken: ZIO[Any, AwsError, NextToken] =
      AwsError.unwrapOptionField("nextToken", nextToken)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.cloudformation.model.ListTypesResponse
  ) extends zio.aws.cloudformation.model.ListTypesResponse.ReadOnly {
    override val typeSummaries
        : Option[List[zio.aws.cloudformation.model.TypeSummary.ReadOnly]] =
      scala
        .Option(impl.typeSummaries())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.cloudformation.model.TypeSummary.wrap(item)
          }.toList
        )
    override val nextToken: Option[NextToken] = scala
      .Option(impl.nextToken())
      .map(value => zio.aws.cloudformation.model.primitives.NextToken(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.cloudformation.model.ListTypesResponse
  ): zio.aws.cloudformation.model.ListTypesResponse.ReadOnly = new Wrapper(impl)
}
