package zio.aws.cloudformation.model
import zio.aws.cloudformation.model.primitives.{NextToken, StackNameOrId}
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters._
final case class ListChangeSetsRequest(
    stackName: StackNameOrId,
    nextToken: Option[NextToken] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.cloudformation.model.ListChangeSetsRequest = {
    import ListChangeSetsRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.cloudformation.model.ListChangeSetsRequest
      .builder()
      .stackName(StackNameOrId.unwrap(stackName): java.lang.String)
      .optionallyWith(
        nextToken.map(value => NextToken.unwrap(value): java.lang.String)
      )(_.nextToken)
      .build()
  }
  def asReadOnly: zio.aws.cloudformation.model.ListChangeSetsRequest.ReadOnly =
    zio.aws.cloudformation.model.ListChangeSetsRequest.wrap(buildAwsValue())
}
object ListChangeSetsRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.cloudformation.model.ListChangeSetsRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.cloudformation.model.ListChangeSetsRequest =
      zio.aws.cloudformation.model
        .ListChangeSetsRequest(stackName, nextToken.map(value => value))
    def stackName: StackNameOrId
    def nextToken: Option[NextToken]
    def getStackName: ZIO[Any, Nothing, StackNameOrId] = ZIO.succeed(stackName)
    def getNextToken: ZIO[Any, AwsError, NextToken] =
      AwsError.unwrapOptionField("nextToken", nextToken)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.cloudformation.model.ListChangeSetsRequest
  ) extends zio.aws.cloudformation.model.ListChangeSetsRequest.ReadOnly {
    override val stackName: StackNameOrId =
      zio.aws.cloudformation.model.primitives.StackNameOrId(impl.stackName())
    override val nextToken: Option[NextToken] = scala
      .Option(impl.nextToken())
      .map(value => zio.aws.cloudformation.model.primitives.NextToken(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.cloudformation.model.ListChangeSetsRequest
  ): zio.aws.cloudformation.model.ListChangeSetsRequest.ReadOnly = new Wrapper(
    impl
  )
}
