package zio.aws.cloudformation.model
import zio.aws.cloudformation.model.primitives.NextToken
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters._
final case class DescribeAccountLimitsRequest(
    nextToken: Option[NextToken] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.cloudformation.model.DescribeAccountLimitsRequest = {
    import DescribeAccountLimitsRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.cloudformation.model.DescribeAccountLimitsRequest
      .builder()
      .optionallyWith(
        nextToken.map(value => NextToken.unwrap(value): java.lang.String)
      )(_.nextToken)
      .build()
  }
  def asReadOnly
      : zio.aws.cloudformation.model.DescribeAccountLimitsRequest.ReadOnly =
    zio.aws.cloudformation.model.DescribeAccountLimitsRequest
      .wrap(buildAwsValue())
}
object DescribeAccountLimitsRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.cloudformation.model.DescribeAccountLimitsRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.cloudformation.model.DescribeAccountLimitsRequest =
      zio.aws.cloudformation.model
        .DescribeAccountLimitsRequest(nextToken.map(value => value))
    def nextToken: Option[NextToken]
    def getNextToken: ZIO[Any, AwsError, NextToken] =
      AwsError.unwrapOptionField("nextToken", nextToken)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.cloudformation.model.DescribeAccountLimitsRequest
  ) extends zio.aws.cloudformation.model.DescribeAccountLimitsRequest.ReadOnly {
    override val nextToken: Option[NextToken] = scala
      .Option(impl.nextToken())
      .map(value => zio.aws.cloudformation.model.primitives.NextToken(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.cloudformation.model.DescribeAccountLimitsRequest
  ): zio.aws.cloudformation.model.DescribeAccountLimitsRequest.ReadOnly =
    new Wrapper(impl)
}
