package zio.aws.cloudformation.model
import zio.aws.cloudformation.model.primitives.{
  StackPolicyDuringUpdateURL,
  TemplateURL,
  DisableRollback,
  StackPolicyDuringUpdateBody,
  StackName,
  NotificationARN,
  ClientRequestToken,
  StackPolicyBody,
  UsePreviousTemplate,
  ResourceType,
  RoleARN,
  StackPolicyURL,
  TemplateBody
}
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters._
final case class UpdateStackRequest(
    stackName: StackName,
    templateBody: Option[TemplateBody] = None,
    templateURL: Option[TemplateURL] = None,
    usePreviousTemplate: Option[UsePreviousTemplate] = None,
    stackPolicyDuringUpdateBody: Option[StackPolicyDuringUpdateBody] = None,
    stackPolicyDuringUpdateURL: Option[StackPolicyDuringUpdateURL] = None,
    parameters: Option[Iterable[zio.aws.cloudformation.model.Parameter]] = None,
    capabilities: Option[Iterable[zio.aws.cloudformation.model.Capability]] =
      None,
    resourceTypes: Option[Iterable[ResourceType]] = None,
    roleARN: Option[RoleARN] = None,
    rollbackConfiguration: Option[
      zio.aws.cloudformation.model.RollbackConfiguration
    ] = None,
    stackPolicyBody: Option[StackPolicyBody] = None,
    stackPolicyURL: Option[StackPolicyURL] = None,
    notificationARNs: Option[Iterable[NotificationARN]] = None,
    tags: Option[Iterable[zio.aws.cloudformation.model.Tag]] = None,
    disableRollback: Option[DisableRollback] = None,
    clientRequestToken: Option[ClientRequestToken] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.cloudformation.model.UpdateStackRequest = {
    import UpdateStackRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.cloudformation.model.UpdateStackRequest
      .builder()
      .stackName(StackName.unwrap(stackName): java.lang.String)
      .optionallyWith(
        templateBody.map(value => TemplateBody.unwrap(value): java.lang.String)
      )(_.templateBody)
      .optionallyWith(
        templateURL.map(value => TemplateURL.unwrap(value): java.lang.String)
      )(_.templateURL)
      .optionallyWith(
        usePreviousTemplate.map(value =>
          UsePreviousTemplate.unwrap(value): java.lang.Boolean
        )
      )(_.usePreviousTemplate)
      .optionallyWith(
        stackPolicyDuringUpdateBody.map(value =>
          StackPolicyDuringUpdateBody.unwrap(value): java.lang.String
        )
      )(_.stackPolicyDuringUpdateBody)
      .optionallyWith(
        stackPolicyDuringUpdateURL.map(value =>
          StackPolicyDuringUpdateURL.unwrap(value): java.lang.String
        )
      )(_.stackPolicyDuringUpdateURL)
      .optionallyWith(
        parameters.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.parameters)
      .optionallyWith(
        capabilities.map(value =>
          value.map { item =>
            item.unwrap.toString
          }.asJavaCollection
        )
      )(_.capabilitiesWithStrings)
      .optionallyWith(
        resourceTypes.map(value =>
          value.map { item =>
            ResourceType.unwrap(item): java.lang.String
          }.asJavaCollection
        )
      )(_.resourceTypes)
      .optionallyWith(
        roleARN.map(value => RoleARN.unwrap(value): java.lang.String)
      )(_.roleARN)
      .optionallyWith(
        rollbackConfiguration.map(value => value.buildAwsValue())
      )(_.rollbackConfiguration)
      .optionallyWith(
        stackPolicyBody.map(value =>
          StackPolicyBody.unwrap(value): java.lang.String
        )
      )(_.stackPolicyBody)
      .optionallyWith(
        stackPolicyURL.map(value =>
          StackPolicyURL.unwrap(value): java.lang.String
        )
      )(_.stackPolicyURL)
      .optionallyWith(
        notificationARNs.map(value =>
          value.map { item =>
            NotificationARN.unwrap(item): java.lang.String
          }.asJavaCollection
        )
      )(_.notificationARNs)
      .optionallyWith(
        tags.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.tags)
      .optionallyWith(
        disableRollback.map(value =>
          DisableRollback.unwrap(value): java.lang.Boolean
        )
      )(_.disableRollback)
      .optionallyWith(
        clientRequestToken.map(value =>
          ClientRequestToken.unwrap(value): java.lang.String
        )
      )(_.clientRequestToken)
      .build()
  }
  def asReadOnly: zio.aws.cloudformation.model.UpdateStackRequest.ReadOnly =
    zio.aws.cloudformation.model.UpdateStackRequest.wrap(buildAwsValue())
}
object UpdateStackRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.cloudformation.model.UpdateStackRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.cloudformation.model.UpdateStackRequest =
      zio.aws.cloudformation.model.UpdateStackRequest(
        stackName,
        templateBody.map(value => value),
        templateURL.map(value => value),
        usePreviousTemplate.map(value => value),
        stackPolicyDuringUpdateBody.map(value => value),
        stackPolicyDuringUpdateURL.map(value => value),
        parameters.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        capabilities.map(value => value),
        resourceTypes.map(value => value),
        roleARN.map(value => value),
        rollbackConfiguration.map(value => value.asEditable),
        stackPolicyBody.map(value => value),
        stackPolicyURL.map(value => value),
        notificationARNs.map(value => value),
        tags.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        disableRollback.map(value => value),
        clientRequestToken.map(value => value)
      )
    def stackName: StackName
    def templateBody: Option[TemplateBody]
    def templateURL: Option[TemplateURL]
    def usePreviousTemplate: Option[UsePreviousTemplate]
    def stackPolicyDuringUpdateBody: Option[StackPolicyDuringUpdateBody]
    def stackPolicyDuringUpdateURL: Option[StackPolicyDuringUpdateURL]
    def parameters
        : Option[List[zio.aws.cloudformation.model.Parameter.ReadOnly]]
    def capabilities: Option[List[zio.aws.cloudformation.model.Capability]]
    def resourceTypes: Option[List[ResourceType]]
    def roleARN: Option[RoleARN]
    def rollbackConfiguration
        : Option[zio.aws.cloudformation.model.RollbackConfiguration.ReadOnly]
    def stackPolicyBody: Option[StackPolicyBody]
    def stackPolicyURL: Option[StackPolicyURL]
    def notificationARNs: Option[List[NotificationARN]]
    def tags: Option[List[zio.aws.cloudformation.model.Tag.ReadOnly]]
    def disableRollback: Option[DisableRollback]
    def clientRequestToken: Option[ClientRequestToken]
    def getStackName: ZIO[Any, Nothing, StackName] = ZIO.succeed(stackName)
    def getTemplateBody: ZIO[Any, AwsError, TemplateBody] =
      AwsError.unwrapOptionField("templateBody", templateBody)
    def getTemplateURL: ZIO[Any, AwsError, TemplateURL] =
      AwsError.unwrapOptionField("templateURL", templateURL)
    def getUsePreviousTemplate: ZIO[Any, AwsError, UsePreviousTemplate] =
      AwsError.unwrapOptionField("usePreviousTemplate", usePreviousTemplate)
    def getStackPolicyDuringUpdateBody
        : ZIO[Any, AwsError, StackPolicyDuringUpdateBody] =
      AwsError.unwrapOptionField(
        "stackPolicyDuringUpdateBody",
        stackPolicyDuringUpdateBody
      )
    def getStackPolicyDuringUpdateURL
        : ZIO[Any, AwsError, StackPolicyDuringUpdateURL] =
      AwsError.unwrapOptionField(
        "stackPolicyDuringUpdateURL",
        stackPolicyDuringUpdateURL
      )
    def getParameters: ZIO[Any, AwsError, List[
      zio.aws.cloudformation.model.Parameter.ReadOnly
    ]] = AwsError.unwrapOptionField("parameters", parameters)
    def getCapabilities
        : ZIO[Any, AwsError, List[zio.aws.cloudformation.model.Capability]] =
      AwsError.unwrapOptionField("capabilities", capabilities)
    def getResourceTypes: ZIO[Any, AwsError, List[ResourceType]] =
      AwsError.unwrapOptionField("resourceTypes", resourceTypes)
    def getRoleARN: ZIO[Any, AwsError, RoleARN] =
      AwsError.unwrapOptionField("roleARN", roleARN)
    def getRollbackConfiguration: ZIO[
      Any,
      AwsError,
      zio.aws.cloudformation.model.RollbackConfiguration.ReadOnly
    ] =
      AwsError.unwrapOptionField("rollbackConfiguration", rollbackConfiguration)
    def getStackPolicyBody: ZIO[Any, AwsError, StackPolicyBody] =
      AwsError.unwrapOptionField("stackPolicyBody", stackPolicyBody)
    def getStackPolicyURL: ZIO[Any, AwsError, StackPolicyURL] =
      AwsError.unwrapOptionField("stackPolicyURL", stackPolicyURL)
    def getNotificationARNs: ZIO[Any, AwsError, List[NotificationARN]] =
      AwsError.unwrapOptionField("notificationARNs", notificationARNs)
    def getTags
        : ZIO[Any, AwsError, List[zio.aws.cloudformation.model.Tag.ReadOnly]] =
      AwsError.unwrapOptionField("tags", tags)
    def getDisableRollback: ZIO[Any, AwsError, DisableRollback] =
      AwsError.unwrapOptionField("disableRollback", disableRollback)
    def getClientRequestToken: ZIO[Any, AwsError, ClientRequestToken] =
      AwsError.unwrapOptionField("clientRequestToken", clientRequestToken)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.cloudformation.model.UpdateStackRequest
  ) extends zio.aws.cloudformation.model.UpdateStackRequest.ReadOnly {
    override val stackName: StackName =
      zio.aws.cloudformation.model.primitives.StackName(impl.stackName())
    override val templateBody: Option[TemplateBody] = scala
      .Option(impl.templateBody())
      .map(value => zio.aws.cloudformation.model.primitives.TemplateBody(value))
    override val templateURL: Option[TemplateURL] = scala
      .Option(impl.templateURL())
      .map(value => zio.aws.cloudformation.model.primitives.TemplateURL(value))
    override val usePreviousTemplate: Option[UsePreviousTemplate] = scala
      .Option(impl.usePreviousTemplate())
      .map(value =>
        zio.aws.cloudformation.model.primitives.UsePreviousTemplate(value)
      )
    override val stackPolicyDuringUpdateBody
        : Option[StackPolicyDuringUpdateBody] = scala
      .Option(impl.stackPolicyDuringUpdateBody())
      .map(value =>
        zio.aws.cloudformation.model.primitives
          .StackPolicyDuringUpdateBody(value)
      )
    override val stackPolicyDuringUpdateURL
        : Option[StackPolicyDuringUpdateURL] = scala
      .Option(impl.stackPolicyDuringUpdateURL())
      .map(value =>
        zio.aws.cloudformation.model.primitives
          .StackPolicyDuringUpdateURL(value)
      )
    override val parameters
        : Option[List[zio.aws.cloudformation.model.Parameter.ReadOnly]] = scala
      .Option(impl.parameters())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.cloudformation.model.Parameter.wrap(item)
        }.toList
      )
    override val capabilities
        : Option[List[zio.aws.cloudformation.model.Capability]] = scala
      .Option(impl.capabilities())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.cloudformation.model.Capability.wrap(item)
        }.toList
      )
    override val resourceTypes: Option[List[ResourceType]] = scala
      .Option(impl.resourceTypes())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.cloudformation.model.primitives.ResourceType(item)
        }.toList
      )
    override val roleARN: Option[RoleARN] = scala
      .Option(impl.roleARN())
      .map(value => zio.aws.cloudformation.model.primitives.RoleARN(value))
    override val rollbackConfiguration
        : Option[zio.aws.cloudformation.model.RollbackConfiguration.ReadOnly] =
      scala
        .Option(impl.rollbackConfiguration())
        .map(value =>
          zio.aws.cloudformation.model.RollbackConfiguration.wrap(value)
        )
    override val stackPolicyBody: Option[StackPolicyBody] = scala
      .Option(impl.stackPolicyBody())
      .map(value =>
        zio.aws.cloudformation.model.primitives.StackPolicyBody(value)
      )
    override val stackPolicyURL: Option[StackPolicyURL] = scala
      .Option(impl.stackPolicyURL())
      .map(value =>
        zio.aws.cloudformation.model.primitives.StackPolicyURL(value)
      )
    override val notificationARNs: Option[List[NotificationARN]] = scala
      .Option(impl.notificationARNs())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.cloudformation.model.primitives.NotificationARN(item)
        }.toList
      )
    override val tags: Option[List[zio.aws.cloudformation.model.Tag.ReadOnly]] =
      scala
        .Option(impl.tags())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.cloudformation.model.Tag.wrap(item)
          }.toList
        )
    override val disableRollback: Option[DisableRollback] = scala
      .Option(impl.disableRollback())
      .map(value =>
        zio.aws.cloudformation.model.primitives.DisableRollback(value)
      )
    override val clientRequestToken: Option[ClientRequestToken] = scala
      .Option(impl.clientRequestToken())
      .map(value =>
        zio.aws.cloudformation.model.primitives.ClientRequestToken(value)
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.cloudformation.model.UpdateStackRequest
  ): zio.aws.cloudformation.model.UpdateStackRequest.ReadOnly = new Wrapper(
    impl
  )
}
