package zio.aws.cloudformation.model
import zio.aws.cloudformation.model.primitives.{
  Timestamp,
  ClientRequestToken,
  StackSetId,
  RoleARN,
  RetainStacksNullable,
  ExecutionRoleName
}
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import java.time.Instant
import scala.jdk.CollectionConverters._
final case class StackSetOperation(
    operationId: Option[ClientRequestToken] = None,
    stackSetId: Option[StackSetId] = None,
    action: Option[zio.aws.cloudformation.model.StackSetOperationAction] = None,
    status: Option[zio.aws.cloudformation.model.StackSetOperationStatus] = None,
    operationPreferences: Option[
      zio.aws.cloudformation.model.StackSetOperationPreferences
    ] = None,
    retainStacks: Option[RetainStacksNullable] = None,
    administrationRoleARN: Option[RoleARN] = None,
    executionRoleName: Option[ExecutionRoleName] = None,
    creationTimestamp: Option[Timestamp] = None,
    endTimestamp: Option[Timestamp] = None,
    deploymentTargets: Option[zio.aws.cloudformation.model.DeploymentTargets] =
      None,
    stackSetDriftDetectionDetails: Option[
      zio.aws.cloudformation.model.StackSetDriftDetectionDetails
    ] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.cloudformation.model.StackSetOperation = {
    import StackSetOperation.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.cloudformation.model.StackSetOperation
      .builder()
      .optionallyWith(
        operationId.map(value =>
          ClientRequestToken.unwrap(value): java.lang.String
        )
      )(_.operationId)
      .optionallyWith(
        stackSetId.map(value => StackSetId.unwrap(value): java.lang.String)
      )(_.stackSetId)
      .optionallyWith(action.map(value => value.unwrap))(_.action)
      .optionallyWith(status.map(value => value.unwrap))(_.status)
      .optionallyWith(operationPreferences.map(value => value.buildAwsValue()))(
        _.operationPreferences
      )
      .optionallyWith(
        retainStacks.map(value =>
          RetainStacksNullable.unwrap(value): java.lang.Boolean
        )
      )(_.retainStacks)
      .optionallyWith(
        administrationRoleARN.map(value =>
          RoleARN.unwrap(value): java.lang.String
        )
      )(_.administrationRoleARN)
      .optionallyWith(
        executionRoleName.map(value =>
          ExecutionRoleName.unwrap(value): java.lang.String
        )
      )(_.executionRoleName)
      .optionallyWith(
        creationTimestamp.map(value => Timestamp.unwrap(value): Instant)
      )(_.creationTimestamp)
      .optionallyWith(
        endTimestamp.map(value => Timestamp.unwrap(value): Instant)
      )(_.endTimestamp)
      .optionallyWith(deploymentTargets.map(value => value.buildAwsValue()))(
        _.deploymentTargets
      )
      .optionallyWith(
        stackSetDriftDetectionDetails.map(value => value.buildAwsValue())
      )(_.stackSetDriftDetectionDetails)
      .build()
  }
  def asReadOnly: zio.aws.cloudformation.model.StackSetOperation.ReadOnly =
    zio.aws.cloudformation.model.StackSetOperation.wrap(buildAwsValue())
}
object StackSetOperation {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.cloudformation.model.StackSetOperation
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.cloudformation.model.StackSetOperation =
      zio.aws.cloudformation.model.StackSetOperation(
        operationId.map(value => value),
        stackSetId.map(value => value),
        action.map(value => value),
        status.map(value => value),
        operationPreferences.map(value => value.asEditable),
        retainStacks.map(value => value),
        administrationRoleARN.map(value => value),
        executionRoleName.map(value => value),
        creationTimestamp.map(value => value),
        endTimestamp.map(value => value),
        deploymentTargets.map(value => value.asEditable),
        stackSetDriftDetectionDetails.map(value => value.asEditable)
      )
    def operationId: Option[ClientRequestToken]
    def stackSetId: Option[StackSetId]
    def action: Option[zio.aws.cloudformation.model.StackSetOperationAction]
    def status: Option[zio.aws.cloudformation.model.StackSetOperationStatus]
    def operationPreferences: Option[
      zio.aws.cloudformation.model.StackSetOperationPreferences.ReadOnly
    ]
    def retainStacks: Option[RetainStacksNullable]
    def administrationRoleARN: Option[RoleARN]
    def executionRoleName: Option[ExecutionRoleName]
    def creationTimestamp: Option[Timestamp]
    def endTimestamp: Option[Timestamp]
    def deploymentTargets
        : Option[zio.aws.cloudformation.model.DeploymentTargets.ReadOnly]
    def stackSetDriftDetectionDetails: Option[
      zio.aws.cloudformation.model.StackSetDriftDetectionDetails.ReadOnly
    ]
    def getOperationId: ZIO[Any, AwsError, ClientRequestToken] =
      AwsError.unwrapOptionField("operationId", operationId)
    def getStackSetId: ZIO[Any, AwsError, StackSetId] =
      AwsError.unwrapOptionField("stackSetId", stackSetId)
    def getAction: ZIO[
      Any,
      AwsError,
      zio.aws.cloudformation.model.StackSetOperationAction
    ] = AwsError.unwrapOptionField("action", action)
    def getStatus: ZIO[
      Any,
      AwsError,
      zio.aws.cloudformation.model.StackSetOperationStatus
    ] = AwsError.unwrapOptionField("status", status)
    def getOperationPreferences: ZIO[
      Any,
      AwsError,
      zio.aws.cloudformation.model.StackSetOperationPreferences.ReadOnly
    ] = AwsError.unwrapOptionField("operationPreferences", operationPreferences)
    def getRetainStacks: ZIO[Any, AwsError, RetainStacksNullable] =
      AwsError.unwrapOptionField("retainStacks", retainStacks)
    def getAdministrationRoleARN: ZIO[Any, AwsError, RoleARN] =
      AwsError.unwrapOptionField("administrationRoleARN", administrationRoleARN)
    def getExecutionRoleName: ZIO[Any, AwsError, ExecutionRoleName] =
      AwsError.unwrapOptionField("executionRoleName", executionRoleName)
    def getCreationTimestamp: ZIO[Any, AwsError, Timestamp] =
      AwsError.unwrapOptionField("creationTimestamp", creationTimestamp)
    def getEndTimestamp: ZIO[Any, AwsError, Timestamp] =
      AwsError.unwrapOptionField("endTimestamp", endTimestamp)
    def getDeploymentTargets: ZIO[
      Any,
      AwsError,
      zio.aws.cloudformation.model.DeploymentTargets.ReadOnly
    ] = AwsError.unwrapOptionField("deploymentTargets", deploymentTargets)
    def getStackSetDriftDetectionDetails: ZIO[
      Any,
      AwsError,
      zio.aws.cloudformation.model.StackSetDriftDetectionDetails.ReadOnly
    ] = AwsError.unwrapOptionField(
      "stackSetDriftDetectionDetails",
      stackSetDriftDetectionDetails
    )
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.cloudformation.model.StackSetOperation
  ) extends zio.aws.cloudformation.model.StackSetOperation.ReadOnly {
    override val operationId: Option[ClientRequestToken] = scala
      .Option(impl.operationId())
      .map(value =>
        zio.aws.cloudformation.model.primitives.ClientRequestToken(value)
      )
    override val stackSetId: Option[StackSetId] = scala
      .Option(impl.stackSetId())
      .map(value => zio.aws.cloudformation.model.primitives.StackSetId(value))
    override val action
        : Option[zio.aws.cloudformation.model.StackSetOperationAction] = scala
      .Option(impl.action())
      .map(value =>
        zio.aws.cloudformation.model.StackSetOperationAction.wrap(value)
      )
    override val status
        : Option[zio.aws.cloudformation.model.StackSetOperationStatus] = scala
      .Option(impl.status())
      .map(value =>
        zio.aws.cloudformation.model.StackSetOperationStatus.wrap(value)
      )
    override val operationPreferences: Option[
      zio.aws.cloudformation.model.StackSetOperationPreferences.ReadOnly
    ] = scala
      .Option(impl.operationPreferences())
      .map(value =>
        zio.aws.cloudformation.model.StackSetOperationPreferences.wrap(value)
      )
    override val retainStacks: Option[RetainStacksNullable] = scala
      .Option(impl.retainStacks())
      .map(value =>
        zio.aws.cloudformation.model.primitives.RetainStacksNullable(value)
      )
    override val administrationRoleARN: Option[RoleARN] = scala
      .Option(impl.administrationRoleARN())
      .map(value => zio.aws.cloudformation.model.primitives.RoleARN(value))
    override val executionRoleName: Option[ExecutionRoleName] = scala
      .Option(impl.executionRoleName())
      .map(value =>
        zio.aws.cloudformation.model.primitives.ExecutionRoleName(value)
      )
    override val creationTimestamp: Option[Timestamp] = scala
      .Option(impl.creationTimestamp())
      .map(value => zio.aws.cloudformation.model.primitives.Timestamp(value))
    override val endTimestamp: Option[Timestamp] = scala
      .Option(impl.endTimestamp())
      .map(value => zio.aws.cloudformation.model.primitives.Timestamp(value))
    override val deploymentTargets
        : Option[zio.aws.cloudformation.model.DeploymentTargets.ReadOnly] =
      scala
        .Option(impl.deploymentTargets())
        .map(value =>
          zio.aws.cloudformation.model.DeploymentTargets.wrap(value)
        )
    override val stackSetDriftDetectionDetails: Option[
      zio.aws.cloudformation.model.StackSetDriftDetectionDetails.ReadOnly
    ] = scala
      .Option(impl.stackSetDriftDetectionDetails())
      .map(value =>
        zio.aws.cloudformation.model.StackSetDriftDetectionDetails.wrap(value)
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.cloudformation.model.StackSetOperation
  ): zio.aws.cloudformation.model.StackSetOperation.ReadOnly = new Wrapper(impl)
}
