package zio.aws.cloudformation.model
import zio.aws.cloudformation.model.primitives.{
  LogicalResourceId,
  Timestamp,
  StackId,
  PhysicalResourceId,
  ResourceType,
  Properties
}
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import java.time.Instant
import scala.jdk.CollectionConverters._
final case class StackResourceDrift(
    stackId: StackId,
    logicalResourceId: LogicalResourceId,
    physicalResourceId: Option[PhysicalResourceId] = None,
    physicalResourceIdContext: Option[Iterable[
      zio.aws.cloudformation.model.PhysicalResourceIdContextKeyValuePair
    ]] = None,
    resourceType: ResourceType,
    expectedProperties: Option[Properties] = None,
    actualProperties: Option[Properties] = None,
    propertyDifferences: Option[
      Iterable[zio.aws.cloudformation.model.PropertyDifference]
    ] = None,
    stackResourceDriftStatus: zio.aws.cloudformation.model.StackResourceDriftStatus,
    timestamp: Timestamp,
    moduleInfo: Option[zio.aws.cloudformation.model.ModuleInfo] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.cloudformation.model.StackResourceDrift = {
    import StackResourceDrift.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.cloudformation.model.StackResourceDrift
      .builder()
      .stackId(StackId.unwrap(stackId): java.lang.String)
      .logicalResourceId(
        LogicalResourceId.unwrap(logicalResourceId): java.lang.String
      )
      .optionallyWith(
        physicalResourceId.map(value =>
          PhysicalResourceId.unwrap(value): java.lang.String
        )
      )(_.physicalResourceId)
      .optionallyWith(
        physicalResourceIdContext.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.physicalResourceIdContext)
      .resourceType(ResourceType.unwrap(resourceType): java.lang.String)
      .optionallyWith(
        expectedProperties.map(value =>
          Properties.unwrap(value): java.lang.String
        )
      )(_.expectedProperties)
      .optionallyWith(
        actualProperties.map(value =>
          Properties.unwrap(value): java.lang.String
        )
      )(_.actualProperties)
      .optionallyWith(
        propertyDifferences.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.propertyDifferences)
      .stackResourceDriftStatus(stackResourceDriftStatus.unwrap)
      .timestamp(Timestamp.unwrap(timestamp): Instant)
      .optionallyWith(moduleInfo.map(value => value.buildAwsValue()))(
        _.moduleInfo
      )
      .build()
  }
  def asReadOnly: zio.aws.cloudformation.model.StackResourceDrift.ReadOnly =
    zio.aws.cloudformation.model.StackResourceDrift.wrap(buildAwsValue())
}
object StackResourceDrift {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.cloudformation.model.StackResourceDrift
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.cloudformation.model.StackResourceDrift =
      zio.aws.cloudformation.model.StackResourceDrift(
        stackId,
        logicalResourceId,
        physicalResourceId.map(value => value),
        physicalResourceIdContext.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        resourceType,
        expectedProperties.map(value => value),
        actualProperties.map(value => value),
        propertyDifferences.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        stackResourceDriftStatus,
        timestamp,
        moduleInfo.map(value => value.asEditable)
      )
    def stackId: StackId
    def logicalResourceId: LogicalResourceId
    def physicalResourceId: Option[PhysicalResourceId]
    def physicalResourceIdContext: Option[List[
      zio.aws.cloudformation.model.PhysicalResourceIdContextKeyValuePair.ReadOnly
    ]]
    def resourceType: ResourceType
    def expectedProperties: Option[Properties]
    def actualProperties: Option[Properties]
    def propertyDifferences
        : Option[List[zio.aws.cloudformation.model.PropertyDifference.ReadOnly]]
    def stackResourceDriftStatus
        : zio.aws.cloudformation.model.StackResourceDriftStatus
    def timestamp: Timestamp
    def moduleInfo: Option[zio.aws.cloudformation.model.ModuleInfo.ReadOnly]
    def getStackId: ZIO[Any, Nothing, StackId] = ZIO.succeed(stackId)
    def getLogicalResourceId: ZIO[Any, Nothing, LogicalResourceId] =
      ZIO.succeed(logicalResourceId)
    def getPhysicalResourceId: ZIO[Any, AwsError, PhysicalResourceId] =
      AwsError.unwrapOptionField("physicalResourceId", physicalResourceId)
    def getPhysicalResourceIdContext: ZIO[Any, AwsError, List[
      zio.aws.cloudformation.model.PhysicalResourceIdContextKeyValuePair.ReadOnly
    ]] = AwsError.unwrapOptionField(
      "physicalResourceIdContext",
      physicalResourceIdContext
    )
    def getResourceType: ZIO[Any, Nothing, ResourceType] =
      ZIO.succeed(resourceType)
    def getExpectedProperties: ZIO[Any, AwsError, Properties] =
      AwsError.unwrapOptionField("expectedProperties", expectedProperties)
    def getActualProperties: ZIO[Any, AwsError, Properties] =
      AwsError.unwrapOptionField("actualProperties", actualProperties)
    def getPropertyDifferences: ZIO[Any, AwsError, List[
      zio.aws.cloudformation.model.PropertyDifference.ReadOnly
    ]] = AwsError.unwrapOptionField("propertyDifferences", propertyDifferences)
    def getStackResourceDriftStatus: ZIO[
      Any,
      Nothing,
      zio.aws.cloudformation.model.StackResourceDriftStatus
    ] = ZIO.succeed(stackResourceDriftStatus)
    def getTimestamp: ZIO[Any, Nothing, Timestamp] = ZIO.succeed(timestamp)
    def getModuleInfo
        : ZIO[Any, AwsError, zio.aws.cloudformation.model.ModuleInfo.ReadOnly] =
      AwsError.unwrapOptionField("moduleInfo", moduleInfo)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.cloudformation.model.StackResourceDrift
  ) extends zio.aws.cloudformation.model.StackResourceDrift.ReadOnly {
    override val stackId: StackId =
      zio.aws.cloudformation.model.primitives.StackId(impl.stackId())
    override val logicalResourceId: LogicalResourceId =
      zio.aws.cloudformation.model.primitives
        .LogicalResourceId(impl.logicalResourceId())
    override val physicalResourceId: Option[PhysicalResourceId] = scala
      .Option(impl.physicalResourceId())
      .map(value =>
        zio.aws.cloudformation.model.primitives.PhysicalResourceId(value)
      )
    override val physicalResourceIdContext: Option[List[
      zio.aws.cloudformation.model.PhysicalResourceIdContextKeyValuePair.ReadOnly
    ]] = scala
      .Option(impl.physicalResourceIdContext())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.cloudformation.model.PhysicalResourceIdContextKeyValuePair
            .wrap(item)
        }.toList
      )
    override val resourceType: ResourceType =
      zio.aws.cloudformation.model.primitives.ResourceType(impl.resourceType())
    override val expectedProperties: Option[Properties] = scala
      .Option(impl.expectedProperties())
      .map(value => zio.aws.cloudformation.model.primitives.Properties(value))
    override val actualProperties: Option[Properties] = scala
      .Option(impl.actualProperties())
      .map(value => zio.aws.cloudformation.model.primitives.Properties(value))
    override val propertyDifferences: Option[
      List[zio.aws.cloudformation.model.PropertyDifference.ReadOnly]
    ] = scala
      .Option(impl.propertyDifferences())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.cloudformation.model.PropertyDifference.wrap(item)
        }.toList
      )
    override val stackResourceDriftStatus
        : zio.aws.cloudformation.model.StackResourceDriftStatus =
      zio.aws.cloudformation.model.StackResourceDriftStatus
        .wrap(impl.stackResourceDriftStatus())
    override val timestamp: Timestamp =
      zio.aws.cloudformation.model.primitives.Timestamp(impl.timestamp())
    override val moduleInfo
        : Option[zio.aws.cloudformation.model.ModuleInfo.ReadOnly] = scala
      .Option(impl.moduleInfo())
      .map(value => zio.aws.cloudformation.model.ModuleInfo.wrap(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.cloudformation.model.StackResourceDrift
  ): zio.aws.cloudformation.model.StackResourceDrift.ReadOnly = new Wrapper(
    impl
  )
}
