package zio.aws.cloudformation.model
import zio.aws.cloudformation.model.primitives.StackSetName
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters._
final case class DescribeStackSetRequest(
    stackSetName: StackSetName,
    callAs: Option[zio.aws.cloudformation.model.CallAs] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.cloudformation.model.DescribeStackSetRequest = {
    import DescribeStackSetRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.cloudformation.model.DescribeStackSetRequest
      .builder()
      .stackSetName(StackSetName.unwrap(stackSetName): java.lang.String)
      .optionallyWith(callAs.map(value => value.unwrap))(_.callAs)
      .build()
  }
  def asReadOnly
      : zio.aws.cloudformation.model.DescribeStackSetRequest.ReadOnly =
    zio.aws.cloudformation.model.DescribeStackSetRequest.wrap(buildAwsValue())
}
object DescribeStackSetRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.cloudformation.model.DescribeStackSetRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.cloudformation.model.DescribeStackSetRequest =
      zio.aws.cloudformation.model
        .DescribeStackSetRequest(stackSetName, callAs.map(value => value))
    def stackSetName: StackSetName
    def callAs: Option[zio.aws.cloudformation.model.CallAs]
    def getStackSetName: ZIO[Any, Nothing, StackSetName] =
      ZIO.succeed(stackSetName)
    def getCallAs: ZIO[Any, AwsError, zio.aws.cloudformation.model.CallAs] =
      AwsError.unwrapOptionField("callAs", callAs)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.cloudformation.model.DescribeStackSetRequest
  ) extends zio.aws.cloudformation.model.DescribeStackSetRequest.ReadOnly {
    override val stackSetName: StackSetName =
      zio.aws.cloudformation.model.primitives.StackSetName(impl.stackSetName())
    override val callAs: Option[zio.aws.cloudformation.model.CallAs] = scala
      .Option(impl.callAs())
      .map(value => zio.aws.cloudformation.model.CallAs.wrap(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.cloudformation.model.DescribeStackSetRequest
  ): zio.aws.cloudformation.model.DescribeStackSetRequest.ReadOnly =
    new Wrapper(impl)
}
