package zio.aws.cloudformation.model
import scala.jdk.CollectionConverters._
sealed trait Category {
  def unwrap: software.amazon.awssdk.services.cloudformation.model.Category
}
object Category {
  def wrap(
      value: software.amazon.awssdk.services.cloudformation.model.Category
  ): zio.aws.cloudformation.model.Category = value match {
    case software.amazon.awssdk.services.cloudformation.model.Category.UNKNOWN_TO_SDK_VERSION =>
      val r = unknownToSdkVersion
      r
    case software.amazon.awssdk.services.cloudformation.model.Category.REGISTERED =>
      val r = REGISTERED
      r
    case software.amazon.awssdk.services.cloudformation.model.Category.ACTIVATED =>
      val r = ACTIVATED
      r
    case software.amazon.awssdk.services.cloudformation.model.Category.THIRD_PARTY =>
      val r = THIRD_PARTY
      r
    case software.amazon.awssdk.services.cloudformation.model.Category.AWS_TYPES =>
      val r = AWS_TYPES
      r
  }
  case object unknownToSdkVersion
      extends zio.aws.cloudformation.model.Category {
    override def unwrap
        : software.amazon.awssdk.services.cloudformation.model.Category =
      software.amazon.awssdk.services.cloudformation.model.Category.UNKNOWN_TO_SDK_VERSION
  }
  case object REGISTERED extends zio.aws.cloudformation.model.Category {
    override def unwrap
        : software.amazon.awssdk.services.cloudformation.model.Category =
      software.amazon.awssdk.services.cloudformation.model.Category.REGISTERED
  }
  case object ACTIVATED extends zio.aws.cloudformation.model.Category {
    override def unwrap
        : software.amazon.awssdk.services.cloudformation.model.Category =
      software.amazon.awssdk.services.cloudformation.model.Category.ACTIVATED
  }
  case object THIRD_PARTY extends zio.aws.cloudformation.model.Category {
    override def unwrap
        : software.amazon.awssdk.services.cloudformation.model.Category =
      software.amazon.awssdk.services.cloudformation.model.Category.THIRD_PARTY
  }
  case object AWS_TYPES extends zio.aws.cloudformation.model.Category {
    override def unwrap
        : software.amazon.awssdk.services.cloudformation.model.Category =
      software.amazon.awssdk.services.cloudformation.model.Category.AWS_TYPES
  }
}
