package zio.aws.clouddirectory.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters.*
final case class ObjectAttributeUpdate(
    objectAttributeKey: Optional[zio.aws.clouddirectory.model.AttributeKey] =
      Optional.Absent,
    objectAttributeAction: Optional[
      zio.aws.clouddirectory.model.ObjectAttributeAction
    ] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.clouddirectory.model.ObjectAttributeUpdate = {
    import ObjectAttributeUpdate.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.clouddirectory.model.ObjectAttributeUpdate
      .builder()
      .optionallyWith(objectAttributeKey.map(value => value.buildAwsValue()))(
        _.objectAttributeKey
      )
      .optionallyWith(
        objectAttributeAction.map(value => value.buildAwsValue())
      )(_.objectAttributeAction)
      .build()
  }
  def asReadOnly: zio.aws.clouddirectory.model.ObjectAttributeUpdate.ReadOnly =
    zio.aws.clouddirectory.model.ObjectAttributeUpdate.wrap(buildAwsValue())
}
object ObjectAttributeUpdate {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.clouddirectory.model.ObjectAttributeUpdate
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.clouddirectory.model.ObjectAttributeUpdate =
      zio.aws.clouddirectory.model.ObjectAttributeUpdate(
        objectAttributeKey.map(value => value.asEditable),
        objectAttributeAction.map(value => value.asEditable)
      )
    def objectAttributeKey
        : Optional[zio.aws.clouddirectory.model.AttributeKey.ReadOnly]
    def objectAttributeAction
        : Optional[zio.aws.clouddirectory.model.ObjectAttributeAction.ReadOnly]
    def getObjectAttributeKey: ZIO[
      Any,
      AwsError,
      zio.aws.clouddirectory.model.AttributeKey.ReadOnly
    ] = AwsError.unwrapOptionField("objectAttributeKey", objectAttributeKey)
    def getObjectAttributeAction: ZIO[
      Any,
      AwsError,
      zio.aws.clouddirectory.model.ObjectAttributeAction.ReadOnly
    ] =
      AwsError.unwrapOptionField("objectAttributeAction", objectAttributeAction)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.clouddirectory.model.ObjectAttributeUpdate
  ) extends zio.aws.clouddirectory.model.ObjectAttributeUpdate.ReadOnly {
    override val objectAttributeKey
        : Optional[zio.aws.clouddirectory.model.AttributeKey.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.objectAttributeKey())
        .map(value => zio.aws.clouddirectory.model.AttributeKey.wrap(value))
    override val objectAttributeAction: Optional[
      zio.aws.clouddirectory.model.ObjectAttributeAction.ReadOnly
    ] = zio.aws.core.internal
      .optionalFromNullable(impl.objectAttributeAction())
      .map(value =>
        zio.aws.clouddirectory.model.ObjectAttributeAction.wrap(value)
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.clouddirectory.model.ObjectAttributeUpdate
  ): zio.aws.clouddirectory.model.ObjectAttributeUpdate.ReadOnly = new Wrapper(
    impl
  )
}
